-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Fuel_Flow.Motive;
with Fuel_Flow.Pump;
with Fuel_Flow.Gravity;

package Tank.Collector is

   type Instance is new Tank.Instance with private;

   procedure Initialize
     (An_Instance : in out Instance;
      Lbm_Init    : in     Mass_Types.Lbm);

   procedure Set_Motive_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph);

   procedure Set_Motive_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph);

   procedure Set_Gravity_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph);

   procedure Set_Gravity_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph);

   procedure Set_Pump_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph);

   procedure Set_Pump_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph);



   procedure Set_Motive_Flow_In
     (An_Instance : in out Instance;
      Value       : in     Boolean);

   procedure Set_Motive_Flow_Out
     (An_Instance : in out Instance;
      Value       : in     Boolean);

   procedure Set_Pump_Flow_In
     (An_Instance : in out Instance;
      Value       : in     Boolean);

   procedure Set_Pump_Flow_Out
     (An_Instance : in out Instance;
      Value       : in     Boolean);

   procedure Set_Gravity_Flow_In
     (An_Instance : in out Instance;
      Value       : in     Boolean);

   procedure Set_Gravity_Flow_Out
     (An_Instance : in out Instance;
      Value       : in     Boolean);


   --accessors

   function Motive_Rate_In
     (An_Instance : in Instance)
     return Mass_Types.Pph;

   function Motive_Rate_Out
     (An_Instance : in Instance)
     return Mass_Types.Pph;

   function Gravity_Rate_In
     (An_Instance : in Instance)
     return Mass_Types.Pph;

   function Gravity_Rate_Out
     (An_Instance : in Instance)
     return Mass_Types.Pph;

   function Pump_Rate_In
     (An_Instance : in Instance)
     return Mass_Types.Pph;

   function Pump_Rate_Out
     (An_Instance : in Instance)
     return Mass_Types.Pph;




   function Motive_Flow_In
     (An_Instance : in Instance)
     return Boolean;

   function Motive_Flow_Out
     (An_Instance : in Instance)
     return Boolean;

   function Pump_Flow_In
     (An_Instance : in Instance)
     return Boolean;

   function Pump_Flow_Out
     (An_Instance : in Instance)
     return Boolean;

   function Gravity_Flow_In
     (An_Instance : in Instance)
     return Boolean;

   function Gravity_Flow_Out
     (An_Instance : in Instance)
     return Boolean;

private

   type Instance is new Tank.Instance with
     record
        Motive_Flow  : Fuel_Flow.Motive.Instance;
        Pump_Flow    : Fuel_Flow.Pump.Instance;
        Gravity_Flow : Fuel_Flow.Gravity.Instance;
     end record;

end Tank.Collector;
