-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Tank.Collector is

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (An_Instance : in out Instance;
      Lbm_Init    : in     Mass_Types.Lbm)
   is
   begin
      Tank.Initialize (An_Instance,Lbm_Init);
      Fuel_Flow.Gravity.Initialize (An_Instance.Gravity_Flow);
      Fuel_Flow.Motive.Initialize (An_Instance.Motive_Flow);
      Fuel_Flow.Pump.Initialize (An_Instance.Pump_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Initialize()");
         raise;
   end Initialize;

   ------------------------
   -- Set_Motive_Flow_In --
   ------------------------

   procedure Set_Motive_Flow_In
     (An_Instance : in out Instance;
      Value       : in     Boolean)
   is
   begin
      Fuel_Flow.Motive.Set_Motive_Flow_In (An_Instance.Motive_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Motive_Flow_In()");
         raise;
   end Set_Motive_Flow_In;

   -------------------------
   -- Set_Motive_Flow_Out --
   -------------------------

   procedure Set_Motive_Flow_Out
     (An_Instance : in out Instance;
      Value       : in     Boolean)
   is
   begin
      Fuel_Flow.Motive.Set_Motive_Flow_Out (An_Instance.Motive_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Motive_Flow_Out()");
         raise;
   end Set_Motive_Flow_Out;

   ----------------------
   -- Set_Pump_Flow_In --
   ----------------------

   procedure Set_Pump_Flow_In
     (An_Instance : in out Instance;
      Value       : in     Boolean)
   is
   begin
      Fuel_Flow.Pump.Set_Pump_Flow_In (An_Instance.Pump_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Pump_Flow_In()");
         raise;
   end Set_Pump_Flow_In;

   -----------------------
   -- Set_Pump_Flow_Out --
   -----------------------

   procedure Set_Pump_Flow_Out
     (An_Instance : in out Instance;
      Value       : in     Boolean)
   is
   begin
      Fuel_Flow.Pump.Set_Pump_Flow_Out (An_Instance.Pump_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Pump_Flow_Out()");
         raise;
   end Set_Pump_Flow_Out;

   -------------------------
   -- Set_Gravity_Flow_In --
   -------------------------

   procedure Set_Gravity_Flow_In
     (An_Instance : in out Instance;
      Value       : in     Boolean)
   is
   begin
      Fuel_Flow.Gravity.Set_Gravity_Flow_In (An_Instance.Gravity_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Gravity_Flow_In()");
         raise;
   end Set_Gravity_Flow_In;

   --------------------------
   -- Set_Gravity_Flow_Out --
   --------------------------

   procedure Set_Gravity_Flow_Out
     (An_Instance : in out Instance;
      Value       : in     Boolean)
   is
   begin
      Fuel_Flow.Gravity.Set_Gravity_Flow_Out (An_Instance.Gravity_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Gravity_Flow_Out()");
         raise;
   end Set_Gravity_Flow_Out;

   ------------------------
   -- Set_Motive_Rate_In --
   ------------------------

   procedure Set_Motive_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Float)
   is
   begin
      Fuel_Flow.Motive.Set_Rate_In (An_Instance.Motive_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Motive_Rate_In()");
         raise;
   end Set_Motive_Rate_In;

   -------------------------
   -- Set_Motive_Rate_Out --
   -------------------------

   procedure Set_Motive_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Float)
   is
   begin
      Fuel_Flow.Motive.Set_Rate_Out (An_Instance.Motive_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Motive_Rate_Out()");
         raise;
   end Set_Motive_Rate_Out;

   -------------------------
   -- Set_Gravity_Rate_In --
   -------------------------

   procedure Set_Gravity_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Float)
   is
   begin
      Fuel_Flow.Gravity.Set_Rate_In (An_Instance.Gravity_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Gravity_Rate_In()");
         raise;
   end Set_Gravity_Rate_In;

   --------------------------
   -- Set_Gravity_Rate_Out --
   --------------------------

   procedure Set_Gravity_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Float)
   is
   begin
      Fuel_Flow.Gravity.Set_Rate_Out (An_Instance.Gravity_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Gravity_Rate_Out()");
         raise;
   end Set_Gravity_Rate_Out;

   ----------------------
   -- Set_Pump_Rate_In --
   ----------------------

   procedure Set_Pump_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Float)
   is
   begin
      Fuel_Flow.Pump.Set_Rate_In (An_Instance.Pump_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.Set_Pump_Rate_In()");
         raise;
   end Set_Pump_Rate_In;

   -----------------------
   -- Set_Pump_Rate_Out --
   -----------------------

   procedure Set_Pump_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Float)
   is
   begin
      Fuel_Flow.Pump.Set_Rate_Out (An_Instance.Pump_Flow,Value);
   exception
      when others =>
         Log.Report("Tank.Collector.()");
         raise;
   end Set_Pump_Rate_Out;



   --accessors

   function Motive_Rate_In
     (An_Instance : in Instance)
     return Mass_Types.Pph
   is
   begin
      return Fuel_Flow.Motive.Rate_In (An_Instance.Motive_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Motive_Rate_In()");
         raise;
   end Motive_Rate_In;

   function Motive_Rate_Out
     (An_Instance : in Instance)
     return Mass_Types.Pph
   is
   begin
      return Fuel_Flow.Motive.Rate_Out (An_Instance.Motive_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Motive_Rate_Out()");
         raise;
   end Motive_Rate_Out;

   function Gravity_Rate_In
     (An_Instance : in Instance)
     return Mass_Types.Pph
   is
   begin
      return Fuel_Flow.Gravity.Rate_In (An_Instance.Gravity_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Gravity_Rate_In()");
         raise;
   end Gravity_Rate_In;

   function Gravity_Rate_Out
     (An_Instance : in Instance)
     return Mass_Types.Pph
   is
   begin
      return Fuel_Flow.Gravity.Rate_Out (An_Instance.Gravity_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Gravity_Rate_Out()");
         raise;
   end Gravity_Rate_Out;

   function Pump_Rate_In
     (An_Instance : in Instance)
     return Mass_Types.Pph
   is
   begin
      return Fuel_Flow.Pump.Rate_In (An_Instance.Pump_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Pump_Rate_In()");
         raise;
   end Pump_Rate_In;

   function Pump_Rate_Out
     (An_Instance : in Instance)
     return Mass_Types.Pph
   is
   begin
      return Fuel_Flow.Pump.Rate_Out (An_Instance.Pump_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Pump_Rate_Out()");
         raise;
   end Pump_Rate_Out;




   function Motive_Flow_In
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return Fuel_Flow.Motive.Motive_Flow_In (An_Instance.Motive_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Motive_Flow_In()");
         raise;
   end Motive_Flow_In;

   function Motive_Flow_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return Fuel_Flow.Motive.Motive_Flow_Out (An_Instance.Motive_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Motive_Flow_Out()");
         raise;
   end Motive_Flow_Out;

   function Pump_Flow_In
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return Fuel_Flow.Pump.Pump_Flow_In (An_Instance.Pump_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Pump_Flow_In()");
         raise;
   end Pump_Flow_In;

   function Pump_Flow_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return Fuel_Flow.Pump.Pump_Flow_Out (An_Instance.Pump_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Pump_Flow_Out()");
         raise;
   end Pump_Flow_Out;

   function Gravity_Flow_In
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return Fuel_Flow.Gravity.Gravity_Flow_In (An_Instance.Gravity_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Gravity_Flow_In()");
         raise;
   end Gravity_Flow_In;

   function Gravity_Flow_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return Fuel_Flow.Gravity.Gravity_Flow_Out (An_Instance.Gravity_Flow);
   exception
      when others =>
         Log.Report("Tank.Collector.Gravity_Flow_Out()");
         raise;
   end Gravity_Flow_Out;


end Tank.Collector;

