-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Quantity_Sensor_G is

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Amount := 0.0;
      An_Instance.Failed := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;


   procedure Set_Amount
     (An_Instance : in out Instance;
      Amount      : in     Quantity_Type)
   is
   begin
      An_Instance.Amount := Amount;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Amount()");
         raise;
   end Set_Amount;

   function Amount
     (An_Instance : in Instance)
     return Quantity_Type
   is
   begin
      return An_Instance.Amount;
   exception
      when others =>
         Log.Report(Package_Name & ".Amount()");
         raise;
   end Amount;

   function Failed
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Failed;
   exception
      when others =>
         Log.Report(Package_Name & ".Failed()");
         raise;
   end Failed;

   procedure Set_Failed
     (An_Instance  : in out Instance;
      Fail_Command : in     Boolean)
   is
   begin
      An_Instance.Failed := Fail_Command;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Failed()");
         raise;
   end Set_Failed;

   procedure Update
     (An_Instance  : in out Instance;
      Amount       : in     Quantity_type;
      Fail_Command : in     Boolean)
   is
   begin
      An_Instance.Amount := Amount;
      An_Instance.Failed := Fail_Command;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;


end Quantity_Sensor_G;

