-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Mechanical_Two_Position_Valve_G is

   procedure Open
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Open := True;
   exception
      when others =>
         Log.Report(Package_Name & ".Open()");
         raise;
   end Open;

   procedure Close
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Open := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Close()");
         raise;
   end Close;

   function Is_Open
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Open;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Open()");
         raise;
   end Is_Open;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Open := True;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   procedure Update
     (An_Instance   : in out Instance;
      Handle_Pulled : in     Boolean)
   is
   begin
      if Handle_Pulled and Is_Open (An_Instance) then
         Close (An_Instance);
      elsif not Handle_Pulled and not Is_Open (An_Instance) then
         Open (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

end Mechanical_Two_Position_Valve_G;
