-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Electrical_Units_Types;
with Mass_Types;
with Force_Types;
with Coordinate_Types;

package Jpats_Fuel is

   function Fuel_Available return Boolean;
   function Fuel_Pressure return Force_Types.Psi;
   function Fuel_Flow return Mass_Types.Pph;

   function Left_Outside_Probe_Quantity return Mass_Types.Lbm;
   function Left_Middle_Probe_Quantity return Mass_Types.Lbm;
   function Left_Inside_Probe_Quantity return Mass_Types.Lbm;
   function Right_Outside_Probe_Quantity return Mass_Types.Lbm;
   function Right_Middle_Probe_Quantity return Mass_Types.Lbm;
   function Right_Inside_Probe_Quantity return Mass_Types.Lbm;
   function Collector_Probe_Quantity return Mass_Types.Lbm;
   function Auto_Balance_Selected return Boolean;

   function Left_Outside_Probe_Failed return Boolean;
   function Left_Middle_Probe_Failed return Boolean;
   function Left_Inside_Probe_Failed return Boolean;
   function Right_Outside_Probe_Failed return Boolean;
   function Right_Middle_Probe_Failed return Boolean;
   function Right_Inside_Probe_Failed return Boolean;
   function Collector_Probe_Failed return Boolean;


   function Auto_Balance_Fail_Command return Boolean;

   function FUEL_PX_Annunciator_Request return Boolean;
   function FUEL_BAL_Annunciator_Request return Boolean;
   function L_FUEL_LO_Annunciator_Request return Boolean;
   function R_FUEL_LO_Annunciator_Request return Boolean;
   function BOOST_PUMP_Annunciator_Request return Boolean;
   function M_Fuel_Bal_Annunciator_Request return Boolean;


   function Boost_Pump_Load return Electrical_Units_Types.Amps;
   function Left_Fuel_Low_Sensor_Load return Electrical_Units_Types.Amps;
   function Right_Fuel_Low_Sensor_Load return Electrical_Units_Types.Amps;
   function Left_Wing_Transfer_Valve_Load return Electrical_Units_Types.Amps;
   function Right_Wing_Transfer_Valve_Load return Electrical_Units_Types.Amps;


   function Get_Fuel_Tank_Weight return Mass_Types.Lbm;
   function Get_Current_Center_of_Gravity return Coordinate_Types.Reference_System;
   function Get_Moment_of_Inertia return Coordinate_Types.Inertia_Axis;

   function Emer_Firewall_Shutoff return Boolean;


   function Boost_Pump_On_Snd return Float;

   function Pump_Degradation_Request return Boolean;

   function Mffu03 return Boolean;

end Jpats_Fuel;
