-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Fuel.Container;
with Jpats_Fuel.Controller;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Tank;
with Tank_Mass_Property;
with Tank.Collector;
with Log;
with Jpats_Powerplant;

package body Jpats_Fuel is

   function Fuel_Available
     return Boolean
   is
   begin
      return Controller.Fuel_Available_To_Engines;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Fuel_Available()");
         raise;
   end Fuel_Available;

   function Fuel_Pressure
     return Force_Types.Psi
   is
   begin
      return Controller.Fuel_Pressure_To_Engines;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Fuel_Pressure()");
         raise;
   end Fuel_Pressure;

   function Fuel_Flow
     return Mass_Types.Pph
   is
   begin
      return Controller.Fuel_Flow_To_Engines;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Fuel_Flow()");
         raise;
   end Fuel_Flow;

   function Auto_Balance_Fail_Command
     return Boolean
   is
      package Ctnr renames Container;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   begin
      return Ios.Stuck_Fuel_Malf;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Auto_Balance_Fail_Command()");
         raise;
   end Auto_Balance_Fail_Command;

   function Left_Outside_Probe_Quantity
     return Mass_Types.Lbm
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Amount (Ctnr.This_Subsystem.The_Left_Wing_Tank_Outside_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Left_Outside_Probe_Quantity()");
         raise;
   end Left_Outside_Probe_Quantity;

   function Left_Middle_Probe_Quantity
     return Mass_Types.Lbm
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Amount (Ctnr.This_Subsystem.The_Left_Wing_Tank_Middle_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Left_Middle_Probe_Quantity()");
         raise;
   end Left_Middle_Probe_Quantity;

   function Left_Inside_Probe_Quantity
     return Mass_Types.Lbm
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Amount (Ctnr.This_Subsystem.The_Left_Wing_Tank_Inside_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Left_Inside_Probe_Quantity()");
         raise;
   end Left_Inside_Probe_Quantity;

   function Right_Outside_Probe_Quantity
     return Mass_Types.Lbm
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Amount (Ctnr.This_Subsystem.The_Right_Wing_Tank_Outside_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Right_Outside_Probe_Quantity()");
         raise;
   end Right_Outside_Probe_Quantity;

   function Right_Middle_Probe_Quantity
     return Mass_Types.Lbm
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Amount (Ctnr.This_Subsystem.The_Right_Wing_Tank_Middle_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Right_Middle_Probe_Quantity()");
         raise;
   end Right_Middle_Probe_Quantity;

   function Right_Inside_Probe_Quantity
     return Mass_Types.Lbm
   is
      package Ctnr renames Container;
   begin
      return  Ctnr.Fuel_Probe.Amount (Ctnr.This_Subsystem.The_Right_Wing_Tank_Inside_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Right_Inside_Probe_Quantity()");
         raise;
   end Right_Inside_Probe_Quantity;

   function Collector_Probe_Quantity
     return Mass_Types.Lbm
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Amount (Ctnr.This_Subsystem.The_Collector_Tank_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Collector_Probe_Quantity()");
         raise;
   end Collector_Probe_Quantity;

   function Auto_Balance_Selected
     return Boolean
   is
      package Ctnr renames Container;
      package Ele   renames Jpats_Electrical;
      package Ele_T renames Jpats_Electrical_Types;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return Ele.Is_Powered (Ele_T.Fuel_Bal_Cb) and not Io.Fuel_Xfer_Man_Reset_Sw;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Auto_Balance_Selected()");
         raise;
   end Auto_Balance_Selected;

   function Left_Outside_Probe_Failed
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Failed(Ctnr.This_Subsystem.The_Left_Wing_Tank_Outside_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Left_Outside_Probe_Failed()");
         raise;
   end Left_Outside_Probe_Failed;

   function Left_Middle_Probe_Failed
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Failed(Ctnr.This_Subsystem.The_Left_Wing_Tank_Middle_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Left_Middle_Probe_Failed()");
         raise;
   end Left_Middle_Probe_Failed;

   function Left_Inside_Probe_Failed
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Failed(Ctnr.This_Subsystem.The_Left_Wing_Tank_Inside_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Left_Inside_Probe_Failed()");
         raise;
   end Left_Inside_Probe_Failed;

   function Right_Outside_Probe_Failed
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Failed(Ctnr.This_Subsystem.The_Right_Wing_Tank_Outside_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Right_Outside_Probe_Failed()");
         raise;
   end Right_Outside_Probe_Failed;

   function Right_Middle_Probe_Failed
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Failed(Ctnr.This_Subsystem.The_Right_Wing_Tank_Middle_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Right_Middle_Probe_Failed()");
         raise;
   end Right_Middle_Probe_Failed;

   function Right_Inside_Probe_Failed
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Failed(Ctnr.This_Subsystem.The_Right_Wing_Tank_Inside_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Right_Inside_Probe_Failed()");
         raise;
   end Right_Inside_Probe_Failed;

   function Collector_Probe_Failed
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Probe.Failed(Ctnr.This_Subsystem.The_Collector_Tank_Fuel_Probe);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Collector_Probe_Failed()");
         raise;
   end Collector_Probe_Failed;




   function FUEL_PX_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;

--      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      Boost_Pump_Below_Idle_Sw : Boolean := Jpats_Powerplant.Boost_Pump_Below_Idle_Switch;

   begin
      return (Ctnr.Low_Pressure_Switch.Is_Closed (Ctnr.This_Subsystem.The_Low_Pressure_Switch)) or
        Boost_Pump_Below_Idle_Sw;
   exception
      when others =>
         Log.Report("Jpats_Fuel.FUEL_PX_Annunciator_Request()");
         raise;
   end FUEL_PX_Annunciator_Request;



   function FUEL_BAL_Annunciator_Request -- EDM
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Boolean'First;
   exception
      when others =>
         Log.Report("Jpats_Fuel.FUEL_BAL_Annunciator_Request()");
         raise;
   end FUEL_BAL_Annunciator_Request;

   function L_FUEL_LO_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Low_Level_Sensor.Is_Closed (Ctnr.This_Subsystem.The_Left_Wing_Tank_Low_Level_Sensor);
   exception
      when others =>
         Log.Report("Jpats_Fuel.L_FUEL_LO_Annunciator_Request()");
         raise;
   end L_FUEL_LO_Annunciator_Request;

   function  R_FUEL_LO_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Low_Level_Sensor.Is_Closed (Ctnr.This_Subsystem.The_Right_Wing_Tank_Low_Level_Sensor);
   exception
      when others =>
         Log.Report("Jpats_Fuel.R_FUEL_LO_Annunciator_Request()");
         raise;
   end R_FUEL_LO_Annunciator_Request;

   function BOOST_PUMP_Annunciator_Request
     return Boolean
   is
      package Ctnr  renames Container;
      package Ele   renames Jpats_Electrical;
      package Ele_T renames Jpats_Electrical_Types;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return (Ele.Is_Powered (Ele_T.Boost_Pump_Cb) and
              (Io.Boost_Pump_On_Sw or Ctnr.Relay.Is_Closed (Ctnr.This_Subsystem.The_Fuel_Pump_Relay)));
   exception
      when others =>
         Log.Report("Jpats_Fuel.BOOST_PUMP_Annunciator_Request()");
         raise;
   end BOOST_PUMP_Annunciator_Request;



   function M_Fuel_Bal_Annunciator_Request
     return Boolean
   is
      package Ctnr  renames Container;
      package Ele   renames Jpats_Electrical;
      package Ele_T renames Jpats_Electrical_Types;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return Ele.Is_Powered (Ele_T.Fuel_Bal_Cb) and Io.Fuel_Xfer_Man_Reset_Sw;
   exception
      when others =>
         Log.Report("Jpats_Fuel.M_Fuel_Bal_Annunciator_Request()");
         raise;
   end M_Fuel_Bal_Annunciator_Request;



   function Boost_Pump_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Boost_Pump.Load (Ctnr.This_Subsystem.The_Fuel_Boost_Pump);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Boost_Pump_Load()");
         raise;
   end Boost_Pump_Load;

   function Left_Fuel_Low_Sensor_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Low_Level_Sensor.Load (Ctnr.This_Subsystem.The_Left_Wing_Tank_Low_Level_Sensor);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Left_Fuel_Low_Sensor_Load()");
         raise;
   end Left_Fuel_Low_Sensor_Load;

   function Right_Fuel_Low_Sensor_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Fuel_Low_Level_Sensor.Load (Ctnr.This_Subsystem.The_Right_Wing_Tank_Low_Level_Sensor);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Right_Fuel_Low_Sensor_Load()");
         raise;
   end Right_Fuel_Low_Sensor_Load;

   function Left_Wing_Transfer_Valve_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Transfer_Valve.Load (Ctnr.This_Subsystem.The_Left_Wing_Transfer_Valve);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Left_Wing_Transfer_Valve_Load()");
         raise;
   end Left_Wing_Transfer_Valve_Load;

   function Right_Wing_Transfer_Valve_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Transfer_Valve.Load (Ctnr.This_Subsystem.The_Right_Wing_Transfer_Valve);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Right_Wing_Transfer_Valve_Load()");
         raise;
   end Right_Wing_Transfer_Valve_Load;

   function Get_Fuel_Tank_Weight
     return Mass_Types.Lbm
   is
   begin
   --   return Mass_Types.Lbm'first;

 --   return Tank.weight(Container.This_Subsystem.The_Left_Wing_Tank) +
 --          Tank.Weight(Container.This_Subsystem.The_Right_Wing_Tank) +
      --          Tank.Weight(Container.This_Subsystem.The_Collector_Tank);
      return Tank.quantity(Container.This_Subsystem.The_Left_Wing_Tank) +
             Tank.quantity(Container.This_Subsystem.The_Right_Wing_Tank) +
             Tank.quantity(Container.This_Subsystem.The_Collector_Tank);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Get_Fuel_Tank_Weight()");
         raise;
   end Get_Fuel_Tank_Weight;

   function Get_Current_Center_Of_Gravity
     return Coordinate_Types.Reference_System
   is
   begin
        return Container.This_Subsystem.The_Fuel_Cg;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Get_CG()");
         raise;
   end Get_Current_Center_of_Gravity;

   function Get_Moment_Of_Inertia
     return Coordinate_Types.Inertia_Axis
   is
   begin
      return (Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Left_Mass_Property).Xx +
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Right_Mass_Property).Xx +
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Collector_Mass_property).Xx,
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Left_Mass_Property).Yy +
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Right_Mass_Property).Yy +
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Collector_Mass_property).Yy,
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Left_Mass_Property).Zz +
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Right_Mass_Property).Zz +
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Collector_Mass_property).Zz,
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Left_Mass_Property).Xz +
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Right_Mass_Property).Xz +
              Tank_Mass_Property.Get_Moi(Container.This_Subsystem.The_Collector_Mass_property).Xz);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Get_moment()");
         raise;
   end Get_Moment_of_Inertia;

   function Emer_Firewall_Shutoff
     return Boolean
   is
      package Ctnr renames Container;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return Io.Emer_Firewall_Shutoff;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Emer_Firewall_Shutoff()");
         raise;
   end Emer_Firewall_Shutoff;


   function Boost_Pump_On_Snd
     return Float
   is
      package Ctnr renames Container;
      Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;
   begin
      return Sound.Boost_Pump_On;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Boost_Pump_On_Snd()");
         raise;
   end Boost_Pump_On_Snd;

   function Pump_Degradation_Request
     return Boolean
   is
      package Ctnr renames Container;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   begin
      return Ios.Boost_Pump_Auto_Fail_Malf or Ios.Cycling_Malf;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Boost_Pump_Degradation_Request()");
         raise;
   end Pump_Degradation_Request;

   function Mffu03
     return Boolean
   is
      package Ctnr renames Container;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   begin
      return False; --Ios.Stuck_Fuel_Malf;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Mffu03()");
         raise;
   end Mffu03;


end Jpats_Fuel;
