-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Fuel.Container;
with Jpats_Ios_Interface;
with Log;

package body Jpats_Fuel.Ios_Interface is

   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io  : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   package JII renames Jpats_Ios_Interface;

   procedure Fuel_Available_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fuel_Available := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Fuel_Available_Command()");
         raise;
   end Fuel_Available_Command;

   procedure Fill_Tanks_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fill_Tanks := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Fill_Tanks_Command()");
         raise;
   end Fill_Tanks_Command;

   procedure Set_Left_Tank_Quantity_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Set_Left_Tank_Quantity := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Set_Left_Tank_Quantity_Command()");
         raise;
   end Set_Left_Tank_Quantity_Command;

   procedure Left_Tank_Requested_Quantity_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Left_Tank_Requested_Quantity := JII.Convert_To_Float(PData);
      Ios.Set_Left_Tank_Quantity := True;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Left_Tank_Requested_Quantity_Command()");
         raise;
   end Left_Tank_Requested_Quantity_Command;

   procedure Set_Right_Tank_Quantity_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Set_Right_Tank_Quantity := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Set_Right_Tank_Quantity_Command()");
         raise;
   end Set_Right_Tank_Quantity_Command;

   procedure Right_Tank_Requested_Quantity_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Right_Tank_Requested_Quantity := JII.Convert_To_Float(PData);
      Ios.Set_Right_Tank_Quantity := True;
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Right_Tank_Requested_Quantity_Command()");
         raise;
   end Right_Tank_Requested_Quantity_Command;

   procedure Boost_Pump_Auto_Fail_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Boost_Pump_Auto_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Boost_Pump_Auto_Fail_Malf_Command()");
         raise;
   end Boost_Pump_Auto_Fail_Malf_Command;

   procedure Stuck_Fuel_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Stuck_Fuel_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Stuck_Fuel_Malf_Command()");
         raise;
   end Stuck_Fuel_Malf_Command;

   procedure Central_Fuel_Line_Leak_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Central_Fuel_Line_Leak_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Central_Fuel_Line_Leak_Malf_Command()");
         raise;
   end Central_Fuel_Line_Leak_Malf_Command;

   procedure Lo_Fuel_Probe_Fail_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Lo_Fuel_Probe_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Lo_Fuel_Probe_Fail_Malf_Command()");
         raise;
   end Lo_Fuel_Probe_Fail_Malf_Command;

   procedure Cycling_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Cycling_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Cycling_Malf_Command()");
         raise;
   end Cycling_Malf_Command;

   procedure Ri_Fuel_Probe_Fail_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ri_Fuel_Probe_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Ri_Fuel_Probe_Fail_Malf_Command()");
         raise;
   end Ri_Fuel_Probe_Fail_Malf_Command;

   procedure Register_Ios_Variables
   is
   begin
      JPATS_IOS_Interface.Register
        (Name        => "Cycling_Malf",
         Variable    => Ios.Cycling_Malf'Address,
         Set_Routine => Cycling_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Lo_Fuel_Probe_Fail_Malf",
         Variable    => Ios.Lo_Fuel_Probe_Fail_Malf'Address,
         Set_Routine => Lo_Fuel_Probe_Fail_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Left_Fuel_Quantity_Sys",
         Variable    => Ios.Left_Fuel_Quantity_Sys'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Right_Fuel_Quantity_Sys",
         Variable    => Ios.Right_Fuel_Quantity_Sys'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Collector_Quantity",
         Variable    => Ios.Collector_Quantity'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Central_Fuel_Line_Leak_Malf",
         Variable    => Ios.Central_Fuel_Line_Leak_Malf'Address,
         Set_Routine => Central_Fuel_Line_Leak_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Stuck_Fuel_Malf",
         Variable    => Ios.Stuck_Fuel_Malf'Address,
         Set_Routine => Stuck_Fuel_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fuel_Available",
         Variable    => Ios.Fuel_Available'Address,
         Set_Routine => Fuel_Available_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fill_Tanks",
         Variable    => Ios.Fill_Tanks'Address,
         Set_Routine => Fill_Tanks_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Set_Left_Tank_Quantity",
         Variable    => Ios.Set_Left_Tank_Quantity'Address,
         Set_Routine => Set_Left_Tank_Quantity_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Left_Tank_Requested_Quantity",
         Variable    => Ios.Left_Tank_Requested_Quantity'Address,
         Set_Routine => Left_Tank_Requested_Quantity_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Set_Right_Tank_Quantity",
         Variable    => Ios.Set_Right_Tank_Quantity'Address,
         Set_Routine => Set_Right_Tank_Quantity_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Right_Tank_Requested_Quantity",
         Variable    => Ios.Right_Tank_Requested_Quantity'Address,
         Set_Routine => Right_Tank_Requested_Quantity_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Manual_Transfer_Sw",
         Variable    => Ios.Manual_Transfer_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fuel_Xfer_Man_Reset_Sw",
         Variable    => Io.Fuel_Xfer_Man_Reset_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Boost_Pump_On_Sw",
         Variable    => Io.Boost_Pump_On_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Boost_Pump_Auto_Fail_Malf",
         Variable    => Ios.Boost_Pump_Auto_Fail_Malf'Address,
         Set_Routine => Boost_Pump_Auto_Fail_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fuel_Available_Sys",
         Variable    => Ios.Fuel_Available_Sys'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fuel_Px_To_Engines",
         Variable    => Ios.Fuel_Px_To_Engines'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fuel_Flo_To_Engines",
         Variable    => Ios.Fuel_Flo_To_Engines'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Emergency_Shutoff_Valve",
         Variable    => Ios.Emergency_Shutoff_Valve'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ri_Fuel_Probe_Fail_Malf",
         Variable    => Ios.Ri_Fuel_Probe_Fail_Malf'Address,
         Set_Routine => Ri_Fuel_Probe_Fail_Malf_Command'Access
         );

   exception
      when others =>
         Log.Report("Jpats_Fuel.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;


end Jpats_Fuel.Ios_Interface;
