-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Fuel.Container;
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;
with Log;

package body Jpats_Fuel.Io_Interface is

   package JIOT renames Jpats_Io_Types;
   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   procedure Register_Io_Variables
   is
   begin

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "FUEL_XFER_MAN_RESET_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fuel_Xfer_Man_Reset_Sw'Address,
         A_Size          => Io.Fuel_Xfer_Man_Reset_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MAN_FUEL_XFER_L_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Man_Fuel_Xfer_L_Sw'Address,
         A_Size          => Io.Man_Fuel_Xfer_L_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MAN_FUEL_XFER_R_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Man_Fuel_Xfer_R_Sw'Address,
         A_Size          => Io.Man_Fuel_Xfer_R_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "BOOST_PUMP_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Boost_Pump_On_Sw'Address,
         A_Size          => Io.Boost_Pump_On_Sw'Size);

--       Jpats_Io.Map_To_Icd_mnemonic
--         (An_Interface    => JIOT.Flight_Deck,
--          An_Icd_Mnemonic => "BOOST_PUMP_BELOW_IDLE_SW",
--          A_Direction     => IO_Types.Input,
--          An_Address      => Io.Boost_Pump_Below_Idle_Sw'Address,
--          A_Size          => Io.Boost_Pump_Below_Idle_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "EMER_FIREWALL_SHUTOFF",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Emer_Firewall_Shutoff'Address,
         A_Size          => Io.Emer_Firewall_Shutoff'Size);

   exception
      when others =>
         Log.Report("Jpats_Fuel.Io_Interface.Register_Io_Variables()");
         raise;
   end Register_Io_Variables;

end Jpats_Fuel.Io_Interface;

