-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  FUEL SUPPLY SYSTEM
--  The aircraft fuel system (Figure 1-16) provides approximately
--  1100 pounds of usable fuel. Fuel storage is provided
--  by three integral tanks built into a single-piece wing. The
--  left and right wing tanks have a capacity of approximately
--  530 pounds each. The central collector tank holds approximately
--  40 pounds and contains a flip-flop valve to allow
--  inverted feed for aerobatic operations. Single point pressure
--  refueling is the primary refueling method. Gravity fill ports
--  on each wing provide a secondary refueling method. Figure
--  1-17 provides usable fuel information.
--  The single point pressure refueling system fills the left and
--  right wing tanks simultaneously. Fuel level control is
--  accomplished by fuel level shutoff valves. The shutoff
--  valves work in conjunction with the fuel level pilot valves to
--  shut off pressure refueling after the tanks are filled. A pilot
--  valve is located in each wing tank outboard tip. Rising fuel
--  levels close the pilot valves, which closes the fuel level shut-off
--  valves and shuts down the pressure refueling operation.
--  The single point pressure refueling system is equipped with
--  pre-check valves to test pressure refueling shutdown operations.
--  The pre-check valves direct fuel from the pressure
--  refueling adapter directly into the pilot valves. When the
--  pilot valves and shutoff valves are operating properly, pressure
--  refueling shutdown should occur in a matter of seconds.
--  Normal fueling can then proceed.
--  The defuel valve is located in the collector tank. During
--  defueling, suction is applied through the single point receptacle.
--  Fuel in the wing tanks gravity feed to the collector
--  tank, where the fuel is picked up by the defuel valve. Drain
--  valves in each tank allow draining of trapped fuel.
--  Over the wing gravity refueling is possible through two
--  flush mounted filler caps, one on the outer portion of each
--  wing. Fuel capacity when the system is gravity fueled is
--  approximately 15 gallons (100 pounds) greater than with
--  pressure refueling, if filled past the level indication in each
--  wing tank.

--  DISTRIBUTION AND VENTING
--  Fuel in each wing tank gravity drains through lightening
--  holes and flapper valves in ribs, to an inboard fuel cavity.
--  The fuel tends to stay inboard due to the flapper valves
--  located on the inlets to the collector tank. Two transfer jet
--  pumps direct fuel from each wing tank to the collector tank,
--  keeping the collector tank pressurized. A positive/negative
--  G (flip-flop) fuel pickup valve in the collector tank draws
--  fuel for feed to the engine.
--  During inverted flight, a weighted rod in the pickup valve,
--  slides down due to gravity, closes off the normal fuel
--  pickup, and opens the inverted flight fuel pickup. This provides
--  a minimum 15 second supply of fuel regardless of orientation,
--  and prevents air ingestion into the fuel system.
--  Refer to Section V for fuel system limitations. A primary jet
--  pump in the collector tank feeds fuel to the main fuel line
--  and from there to the engine-driven low pressure fuel pump
--  that routes fuel to the engine-driven high pressure fuel pump
--  and the FMU. A vent line is provided which allows the high
--  pressure pump to purge to the collector tank.
--  NOTE
--  If the FUEL PX annunciator illuminates and
--  the boost pump activates during inverted
--  flight, cease inverted flight and notify maintenance
--  after flight.
--  The fuel system incorporates an auto balance system (provided
--  by the EDM) which maintains the fuel load in each
--  wing tank to within 20 pounds (indicated) of the other wing.
--  The system detects fuel load imbalances as displayed on the
--  fuel gage, and activates the solenoid valve to close the
--  motive flow line to the light tank. If the fuel imbalance
--  exceeds 30 pounds for more than two minutes, the amber
--  FUEL BAL annunciator is illuminated and pilot action is
--  required. To manually balance the fuel load, first set the fuel
--  balance switch (right front console, forward cockpit only),
--  placarded FUEL BAL to MAN/RESET. Then, set the manual
--  fuel balance switch (right front console, forward cockpit
--  only), placarded MANUAL FUEL BAL, to L or R, which ever
--  tank is lighter. This activates the solenoid valve to
--  close the motive flow line to the light tank. Once the fuel
--  load has been balanced to within approximately 20 pounds,
--  reset the auto balance system by setting the fuel balance
--  switch back to AUTO. Power for the manual fuel balance
--  switch is provided through a circuit breaker placarded
--  FUEL BAL, located on the generator bus circuit breaker
--  panel in the front cockpit.
--  If a fuel probe fails, the amber FUEL BAL annunciator will
--  illuminate, indicating that the auto balance system has shut
--  off. The low fuel warning lights will continue to provide an
--  accurate indication of minimum fuel level. Approximate
--  wings-level gage indications when a fuel probe fails are as
--  follows:
--    * FP FAIL will display in amber text in the lower center
--  portion of the alternate engine data display.
--    * l If the outer fuel probe fails, the affected tank will
--  show a fuel level drop to the best indication for the
--  next inboard (middle) fuel probe (approximately 445
--  pounds  50 pounds) and remain there until enough
--  fuel is used to drop below the failed fuel probe. Once
--  the fuel level drops to below the failed fuel probe, normal
--  level indications will resume.
--    * If the middle fuel probe fails, the affected tank will
--  show a normal fuel level until the fuel level drops
--  below the outer fuel probe. Fuel level will then drop to
--  the best indication for the next inboard (inner) fuel
--  probe (approximately 308 pounds  50 pounds) and
--  remain there until enough fuel is used to drop below
--  the failed fuel probe. Once the fuel level drops to
--  below the failed fuel probe, normal level indications
--  will resume.
--    * If the inner fuel probe fails, the affected tank will
--  show a normal fuel level until the fuel level drops
--  below the middle fuel probe. Fuel level will then drop
--  to the best indication for the collector tank, which is
--  divided evenly between sides (approximately 20
--  pounds per side).
--    * If the collector tank fuel probe fails, the fuel levels in
--  both wing tanks will each drop by one half the gaged
--  level of the collector tank (approximately 20 pounds
--  per side).

--  The wing tanks are vented to the atmosphere to provide vacuum
--  and pressure relief for the tanks. The wing tanks are
--  internally vented to each other. The fuel transfer jet pumps
--  pressurize the collector tank to approximately 1 to 1.5 psi.
--  Pressure and vacuum relief valves are provided to prevent
--  overpressurization or collapse of the wing tanks during refueling
--  or defueling. If the shutoff valves fail to close, the
--  relief valves in each wing tank will open and relieve excess
--  pressure in the tanks.

--  ENGINE FEED
--  Engine fuel feeds from the collector tank to the two engine-driven
--  fuel pumps. Fuel first passes through the engine-driven
--  low pressure fuel pump, and then through the engine-driven
--  high pressure fuel pump. The collector tank incorporates
--  an electric boost pump and a primary jet pump to
--  deliver fuel from the collector tank to the engine driven low
--  pressure fuel pump.
--  The electric boost pump provides fuel for initial engine start
--  and serves as a backup to the engine-driven low pressure
--  fuel pump. A five psi pressure switch in the motive flow line
--  activates the boost pump anytime fuel pressure drops below
--  five psi and the PCL is above the start ready position (ST
--  READY annunciator illuminated). A redundant circuit in
--  the starter relay also activates the boost pump whenever the
--  starter is activated, regardless of fuel pressure. The primary
--  and fuel transfer jet pumps operate using motive fuel flow
--  supplied from the engine-driven low pressure fuel pump,
--  and are capable of delivering fuel in excess of engine fuel
--  demands. If the electric boost pump fails, if the engine
--  driven low pressure fuel pump fails, or if both low pressure
--  fuel pumps fail, the engine driven high pressure fuel Pump
--  will suction feed sufficient fuel for continued engine operation.
--  If the engine driven high pressure fuel pump fails, the
--  engine will flameout and cannot be restarted.
--  Engine driven high pressure fuel pump suction
--  feed limit is 10 hours of operation.
--  The engine feed line incorporates two manually operated
--  shutoff valves and a fuel filter. One shutoff valve is provided
--  to isolate the fuel system for engine or fuel filter maintenance.
--  The other shutoff valve is actuated by the emergency
--  firewall shutoff handle in the front cockpit, which, when
--  actuated, stops fuel flow.
--  NOTE
--  With the PCL at IDLE, the engine will continue
--  to run for approximately five to ten seconds
--  after the emergency firewall shutoff
--  handle is operated.

--  FUEL QUANTITY INDICATING
--  The fuel quantity indicating system uses seven fuel probes,
--  three in each wing tank, and one in the collector tank. The
--  probes send a signal to each cockpit for visual display of the
--  fuel quantity levels. Failure of a fuel probe generates an FP
--  FAIL message on each alternate engine data display and
--  activates the amber FUEL BAL annunciator in each cockpit.
--  The fuel system includes six annunciators to indicate fuel
--  system operations. The red FUEL PX annunciator indicates
--  low fuel pressure delivery to the engine and is illuminated
--  by activation of the low pressure switch. The green BOOST
--  PUMP annunciator indicates that the electric boost pump
--  has been activated. The boost pump can be manually activated
--  by selecting the BOOST PUMP switch located on
--  each engine/electrical switch panel to ON, or automatically
--  through the operation of the low pressure switch or starter
--  relay during an auto start. When the electric boost pump is
--  automatically actuated through the low pressure switch, the
--  FUEL PX and BOOST PUMP annunciators may cycle until
--  the selection of boost pump to ON. The amber L FUEL LO
--  and R FUEL LO annunciators indicate fuel quantity below
--  approximately 185 pounds in the respective wing tank. Any
--  time indicated fuel imbalance exceeds 30 pounds between
--  the wing tanks, or a fuel probe fails, autobalancing is deactivated
--  and the FUEL BAL annunciator illuminates, indicating
--  the need for pilot action. Any time the fuel balance
--  switch is not in the AUTO position, the green M FUEL BAL
--  annunciator is illuminated.
--  Power for the boost pump is provided through a circuit
--  breaker placarded BOOST PUMP, located on the Battery
--  bus circuit breaker panel in the front cockpit. Power for the
--  low fuel quantity probes is provided through a circuit
--  breaker placarded FUEL QTY LO, also located on the battery
--  bus circuit breaker panel in the front cockpit.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------

private package Jpats_Fuel.Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);
   function Fuel_Available_To_Engines return Boolean;
   function Fuel_Pressure_To_Engines  return Force_Types.Psi;
   function Fuel_Flow_To_Engines      return Mass_Types.Pph;

end Jpats_Fuel.Controller;
