-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Low_Level_Switch_G;
with Quantity_Sensor_G;
with Mechanical_Two_Position_Valve_G;
with Electric_Boost_Pump_G;
with Solenoid_Valve_G;
with Electrical_Units_Types;
with Tank_Mass_Property;
with Tank.Wing;
with Tank.Collector;
with Transfer_Valve_G;
with Force_Types;
with Mass_Types;
with Coil_Relay_G;
with Coordinate_Types;
--     Tank_For_Simulated_Aircraft;

private package Jpats_Fuel.Container is

-- low fuel level sensor for wing tanks
   package Fuel_Low_Level_Sensor is new Low_Level_Switch_G
     (Quantity_Type       => Mass_Types.Lbm,
      Low_Level_Threshold => 112.0,
      Current_Type        => Electrical_Units_Types.Amps,
      Package_Name        => "Jpats_Fuel.Container.Fuel_Low_Level_Sensor");

-- low pressure switch motive flow line
   package Low_Pressure_Switch is new Low_Level_Switch_G
     (Quantity_Type       => Force_Types.Psi,
      Low_Level_Threshold => 10.0,
      Current_Type        => Electrical_Units_Types.Amps,
      Package_Name        => "Jpats_Fuel.Container.Low_Pressure_Switch");

-- fuel probe
   package Fuel_Probe is new Quantity_Sensor_G
     (Quantity_Type => Mass_Types.Lbm,
      Package_Name  => "Jpats_Fuel.Container.Fuel_Probe");

-- firewall fuel shutoff valve
   package Shutoff_Valve is new Mechanical_Two_Position_Valve_G
     (Package_Name  => "Jpats_Fuel.Container.Shutoff_Valve");

-- boost pump
   package Boost_Pump is new Electric_Boost_Pump_G
     (Ampere_Type  => Electrical_Units_Types.Amps,
      Pump_On_Load => 10.5,
      Package_Name => "Jpats_Fuel.Container.Boost_Pump");

-- transfer valves
   package Transfer_Valve is new Transfer_Valve_G
     (Ampere_Type               => Electrical_Units_Types.Amps,
      Valve_Load                => 4.9,
      Open_Restriction_Factor   => 1.0,
      Closed_Restriction_Factor => 0.0,
      Package_Name              => "Jpats_Fuel.Container.Transfer_Valve");

   package Relay is new Coil_Relay_G
     (Ampere_Type  => Electrical_Units_Types.Amps,
      Closed_Load  => 0.05,
      Package_Name => "Jpats_Fuel.Container.Relay");


   type Pressure_Capacitor is array (1..3) of Force_Types.Psi;

   type Instance is
      record
         The_Left_Wing_Tank_Low_Level_Sensor    : Fuel_Low_Level_Sensor.Instance;
         The_Right_Wing_Tank_Low_Level_Sensor   : Fuel_Low_Level_Sensor.Instance;
         The_Left_Wing_Tank_Inside_Fuel_Probe   : Fuel_Probe.Instance;
         The_Left_Wing_Tank_Middle_Fuel_Probe   : Fuel_Probe.Instance;
         The_Left_Wing_Tank_Outside_Fuel_Probe  : Fuel_Probe.Instance;
         The_Right_Wing_Tank_Inside_Fuel_Probe  : Fuel_Probe.Instance;
         The_Right_Wing_Tank_Middle_Fuel_Probe  : Fuel_Probe.Instance;
         The_Right_Wing_Tank_Outside_Fuel_Probe : Fuel_Probe.Instance;
         The_Collector_Tank_Fuel_Probe          : Fuel_Probe.Instance;
         The_Firewall_Fuel_Shutoff_Valve        : Shutoff_Valve.Instance;
         The_Fuel_Boost_Pump                    : Boost_Pump.Instance;
         The_Low_Pressure_Switch                : Low_Pressure_Switch.Instance;
         The_Left_Wing_Transfer_Valve           : Transfer_Valve.Instance;
         The_Right_Wing_Transfer_Valve          : Transfer_Valve.Instance;
         The_Fuel_Pump_Relay                    : Relay.Instance;
         The_Left_Wing_Tank                     : Tank.Wing.Instance;
         The_Right_Wing_Tank                    : Tank.Wing.Instance;
         The_Collector_Tank                     : Tank.Collector.Instance;
         The_Left_Mass_Property                 : Tank_Mass_Property.Instance;
         The_Right_Mass_Property                : Tank_Mass_Property.Instance;
         The_Collector_Mass_Property            : Tank_Mass_Property.Instance;
         The_Fuel_cg                            : Coordinate_Types.Reference_System :=
                                                                 (14.0,0.0,7.0);


         FC_Fuel_Avail_To_Engines       : Boolean         := False;
         FC_Fuel_Px_To_Engines          : Force_Types.Psi := 0.0;
         FC_Fuel_Flo_To_Engines         : Mass_Types.Pph  := 0.0;
         FC_Central_Fuel_Line_Leak_Flow : Mass_Types.Pph  := 0.0;

         FC_In_Inverted_Flight_Timer : Float := 0.0;
         FC_Not_In_Inverted_Flight_Timer : Float := 0.0;
         FC_Central_Fuel_Line_Leak_Malf_Lp : Boolean := False;
         FC_Pressure_Capacitor : Pressure_Capacitor  := (others => 0.0);

         FC_Left_Tank_Fill_Command  : Boolean := False;
         FC_Right_Tank_Fill_Command : Boolean := False;
         FC_Collector_Tank_Fill_Command : Boolean := False;

         FC_Sov_Timer : Float := 0.0;


      end record;
   This_Subsystem : Instance;

   type Io_Interface_Instance is
      record
         -- digital input
         Fuel_Xfer_Man_Reset_Sw                 : Boolean := False;
         Man_Fuel_Xfer_L_Sw                     : Boolean := False;
         Man_Fuel_Xfer_R_Sw                     : Boolean := False;
         Boost_Pump_On_Sw                       : Boolean := False;
         Boost_Pump_Below_Idle_Sw               : Boolean := True;
         Emer_Firewall_Shutoff                  : Boolean := False;
         -- digital output
         -- analog input
         -- analog output
         -- spare
         Spare_Io_1                             : Boolean := False;
      end record;

   Io_Size : constant Integer := 4;
   for Io_Interface_Instance use
      record
         -- spare
         Spare_Io_1                             at  000*Io_Size range 0..31;
         -- digital input
         Fuel_Xfer_Man_Reset_Sw                 at  001*Io_Size range 0..31;
         Man_Fuel_Xfer_L_Sw                     at  002*Io_Size range 0..31;
         Man_Fuel_Xfer_R_Sw                     at  003*Io_Size range 0..31;
         Boost_Pump_On_Sw                       at  004*Io_Size range 0..31;
         Boost_Pump_Below_Idle_Sw               at  005*Io_Size range 0..31;
         Emer_Firewall_Shutoff                  at  006*Io_Size range 0..31;
         -- digital output
         -- analog input
         -- analog output
      end record;
   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         Fuel_Available                  : Boolean := False;
         Fill_Tanks                      : Boolean := False;
         Set_Left_Tank_Quantity          : Boolean := False;
         Left_Tank_Requested_Quantity    : Float := 0.0;
         Set_Right_Tank_Quantity         : Boolean := False;
         Right_Tank_Requested_Quantity   : Float := 0.0;
         Manual_Transfer_Sw              : Integer := 0;
         Emergency_Shutoff_Valve         : Boolean := False;
         Cycling_Malf                    : Boolean := False;
         Boost_Pump_Auto_Fail_Malf       : Boolean := False;
         Stuck_Fuel_Malf                 : Boolean := False;
         Central_Fuel_Line_Leak_Malf     : Boolean := False;
         Lo_Fuel_Probe_Fail_Malf         : Boolean := False;
         Ri_Fuel_Probe_Fail_Malf         : Boolean := False;
         Left_Fuel_Quantity_Sys          : Float := 550.0;
         Right_Fuel_Quantity_Sys         : Float := 550.0;
         Collector_Quantity              : Float := 40.0;
         Fuel_Available_Sys              : Boolean := False;
         Fuel_Px_To_Engines              : Float   := 0.0;
         Fuel_Flo_To_Engines             : Float   := 0.0;
      end record;
   This_Ios_Interface : Ios_Interface_Instance;

   type Sound_Interface_Instance is
      record
         Boost_Pump_On : Float := 0.0;
      end record;
   This_Sound_Interface : Sound_Interface_Instance;

end Jpats_Fuel.Container;

