-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Mass_Types;

package Fuel_Flow is

   type Instance is abstract tagged private;

   procedure Set_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph)
      is abstract;

   procedure Set_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph)
      is abstract;

   procedure Initialize
     (An_Instance : in out Instance)
      is abstract;

   function Rate_In
     (An_Instance : in Instance)
     return Mass_Types.Pph is abstract;

   function Rate_Out
     (An_Instance : in Instance)
     return Mass_Types.Pph is abstract;

private

   type Instance is abstract tagged
      record
         Rate_In  : Mass_Types.Pph;
         Rate_Out : Mass_Types.Pph;
      end record;

end Fuel_Flow;
