-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Fuel_Flow.Motive is

   procedure Set_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph)
   is
   begin
      An_Instance.Rate_In := Value;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Set_Rate_In()");
         raise;
   end Set_Rate_In;

   procedure Set_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph)
   is
   begin
      An_Instance.Rate_Out := Value;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Set_Rate_Out()");
         raise;
   end Set_Rate_Out;

   procedure Set_Motive_Flow_In
     (An_Instance : in out Instance;
      Value       : in     Boolean)
   is
   begin
      An_Instance.Is_Motive_Flow_In := Value;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Set_Motive_Flow_In()");
         raise;
   end Set_Motive_Flow_In;

   procedure Set_Motive_Flow_Out
     (An_Instance : in out Instance;
      Value       : in     Boolean)
   is
   begin
      An_Instance.Is_Motive_Flow_Out := Value;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Set_Motive_Flow_Out()");
         raise;
   end Set_Motive_Flow_Out;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Motive_Flow_In  := False;
      An_Instance.Is_Motive_Flow_Out := False;
      An_Instance.Rate_In  := 0.0;
      An_Instance.Rate_Out := 0.0;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Initialize()");
         raise;
   end Initialize;

   function Rate_In
     (An_Instance : in Instance)
     return Mass_Types.Pph
   is
   begin
      return An_Instance.Rate_In;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Rate_In()");
         raise;
   end Rate_In;

   function Rate_Out
     (An_Instance : in Instance)
     return Mass_Types.Pph
   is
   begin
      return An_Instance.Rate_Out;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Rate_Out()");
         raise;
   end Rate_Out;

   function Motive_Flow_In
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Motive_Flow_In;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Motive_Flow_In()");
         raise;
   end Motive_Flow_In;

   function Motive_Flow_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Motive_Flow_Out;
   exception
      when others =>
         Log.Report("Fuel_Flow.Motive.Motive_Flow_Out()");
         raise;
   end Motive_Flow_Out;


end Fuel_Flow.Motive;
