-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Mass_Types;

package Fuel_Flow.Gravity is

   type Instance is new Fuel_Flow.Instance with private;

   procedure Set_Rate_In
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph);

   procedure Set_Rate_Out
     (An_Instance : in out Instance;
      Value       : in     Mass_Types.Pph);

   procedure Set_Gravity_Flow_In
     (An_Instance : in out Instance;
      Value       : in     Boolean);

   procedure Set_Gravity_Flow_Out
     (An_Instance : in out Instance;
      Value       : in     Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

   function Rate_In
     (An_Instance : in Instance)
      return Mass_Types.Pph;

   function Rate_Out
     (An_Instance : in Instance)
      return Mass_Types.Pph;

   function Gravity_Flow_In
     (An_Instance : in Instance)
      return Boolean;

   function Gravity_Flow_Out
     (An_Instance : in Instance)
      return Boolean;

private

   type Instance is new Fuel_Flow.Instance with
      record
         Is_Gravity_Flow_In  : Boolean;
         Is_Gravity_Flow_Out : Boolean;
      end record;

end Fuel_Flow.Gravity;
