-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|   Engineer:  Yogesh Tupe/Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
with Angle_Types;

package Turn_Indicator is

    type Instance is private;

    procedure Set_Turn_Rate(Bank         :in     Angle_Types.Radians;
                            Q            :in     Angle_Types.Radians_Per_Sec;
                            r            :in     Angle_Types.Radians_Per_Sec;
                            An_Instance  :in out Instance);
    procedure Zero_Ind_Turn_Rate(An_Instance:in out Instance);
    function Get_Turn_Rate(An_Instance :in Instance) return Angle_Types.Radians_Per_Sec;
private
    type Instance is record
        The_Turn_Rate : Angle_Types.Radians_Per_Sec := 0.0;
    end record;

end Turn_Indicator;
