-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe/Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Numerics.Elementary_Functions;   use Ada.Numerics.Elementary_Functions;

package body Turn_Indicator is

    procedure Set_Turn_Rate(bank  :in     Angle_Types.Radians;
                            Q     :in     Angle_Types.Radians_per_Sec;
                            r     :in     Angle_Types.Radians_per_Sec;
                            An_Instance  :in out Instance) is
    begin
        An_Instance.The_Turn_Rate :=  R * Cos(bank) + q * Sin(Bank);
    end Set_Turn_Rate;

    procedure Zero_ind_Turn_Rate (An_Instance :in out Instance) is
    begin
        An_Instance.The_Turn_Rate := 0.0;
    end Zero_ind_Turn_Rate;

    function Get_Turn_Rate(An_Instance :in Instance) return Angle_Types.Radians_Per_Sec is
    begin
        return An_Instance.The_Turn_Rate;
    end Get_Turn_Rate;

end Turn_Indicator;
