-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Length_Types;
with Flight_Instruments_Types;

generic
  Radius_Of_Curvature :  Length_Types.Inches;
  Ball_Diameter       :  Length_Types.Inches;
  Max_Ball_Travel     :  Length_Types.Inches;

package Slip_Indicator is

  type Instance is private;

  procedure Update
    (Ay              :in     Length_Types.Feet_Per_Sec_Sq;
     Az              :in     Length_Types.Feet_Per_Sec_Sq;
     R               :in     Angle_Types.Radians_Per_Sq_Sec;
     Dt              :in     Float;
     An_Instance     :in out Instance);

  --    procedure Zero_Ball
  --     (An_Instance : in out Instance);

  function Position
    (An_Instance :in Instance)
    return Length_Types.Inches;

private

  type Instance is
     record
       Position   : Length_Types.Feet := 0.0;
       Velocity   : Length_Types.Feet_Per_Sec := 0.0;
     end record;

end Slip_Indicator;







