-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
with Ada.Numerics.Elementary_Functions;
use Ada.Numerics.Elementary_Functions;

package body Slip_Indicator is

  procedure Update
    (Ay              :in     Float;
     Az              :in     Float;
     r               :in     Angle_Types.Radians_per_Sq_Sec;
     dt              :in     Float;
     An_Instance     :in out Instance) is

    Ball_Accel        : Float := 0.0;
    Damp              : Float := 4.5;
    Panel_Dist        : Float := 2.25; -- ft
  begin
    Ball_Accel := 1.333 * (- Az * Sin(Arctan(An_Instance.Position*12.0/Radius_Of_Curvature))
                           - Ay * Cos(Arctan(An_Instance.Position*12.0/Radius_Of_Curvature))
                           + Panel_Dist * r)
                  - Damp * An_Instance.Velocity;
--    Ball_Accel := 1.333 * (-3.333* An_Instance.Position * Az -  Ay + Panel_Dist * r)
--                  - Damp * An_Instance.Velocity;
    An_Instance.Velocity  := An_Instance.Velocity + dt * Ball_Accel;
    An_Instance.position  := An_Instance.position + dt * An_Instance.Velocity;

    if  An_Instance.Position*12.0  <  -Max_Ball_Travel  then
      An_Instance.position := -Max_Ball_Travel/12.0;
      An_Instance.Velocity     := 0.0;
    elsif
      An_Instance.Position*12.0 >  Max_Ball_Travel then
      An_Instance.position  := Max_Ball_Travel/12.0;
      An_Instance.Velocity  := 0.0;
    end if;

  end Update;

  function Position
    (An_Instance : in Instance)
    return Length_Types.Inches is
  begin
--    return Ball_Diameter/0.34*An_Instance.Position;
    return 12.0*An_Instance.Position;
  end Position;

end Slip_Indicator;
