-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Flight_Instruments_Types;
with Force_Types;
with Length_Types;
with Mass_Types;
with Temperature_Types;
with Flight_Instruments_Arinc_Labels;
with Arinc_429_Types;
package JPATS_Flight_Instruments is

    --| primary adc
    function primary_Alt return Length_Types.Feet;
    function Primary_VVI return Length_Types.Feet_per_Min;
    function Primary_ias return Length_Types.Knots;
    function Max_Operating_Airspeed return Length_Types.Knots;
    function Primary_Ind_Mach return Length_Types.Mach;
    function Overspeed_Warning return Boolean;
    function Pressure_Alt return Length_Types.Feet;
    function Standby_Alt return Length_Types.Feet;
    function Standby_ias return Length_Types.Knots;
    function Packed_Pressure_Altitude return Arinc_429_Types.Message_Type;
--    function Ball_Pos return Flight_Instruments_Types.Slip_Indicator_Type;

    --| Standby Turn Indicator
    function Get_Standby_Turn_Indicator_Turn_Rate return Float;

    --| The_Primary_Pitot_Probe_Heater
    function Get_Primary_Pitot_Probe_Heater_Is_On return Boolean;
    function Get_Primary_Pitot_Probe_Heater_Load return Float;

    --| The_Secondary_Pitot_Probe_Heater
    function Get_Secondary_Pitot_Probe_Heater_Is_On return Boolean;
    function Get_Secondary_Pitot_Probe_Heater_Load return Float;

    --| The_Angle_of_Attack_Pitot_Probe_Heater
    function Get_Angle_Of_Attack_Pitot_Probe_Heater_Is_On return Boolean;
    function Get_Angle_of_Attack_Vane_Probe_Heater_Load return Float;
    function Overspeed_warn return Boolean;
    -- cws light
    function Anti_Ice_Annunciator_Request return Boolean;
    -- The Stick_Shaker_Is_Active
    function Stick_Shaker_Is_Active  return Boolean;

    function Debug1 return Float;
    function Debug2 return Float;
    function Debug3 return Float;
    function Debug4 return Float;
    function Debug5 return Float;
    function Debug6 return Float;
end JPATS_Flight_Instruments;



