-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with JPATS_Flight_Instruments.Container;
with JPATS_Flight_Instruments_Types;
with Air_Data_Computer;
with Probe_Heater;
with Turn_Indicator;
with JPATS_Simulated_Aircraft;
with JPATS_Secondary_Flight_Controls;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Flight_Instruments_Arinc_Labels;

package body JPATS_Flight_Instruments is
   package Cnt renames Container;

--| Air Data Computer

    function primary_Alt return Length_Types.Feet is
    begin
        return Air_Data_Computer.Primary_ind_alt(CNT.This_Subsystem.The_Primary_adc);
    end Primary_Alt;

    function Primary_Vvi return Length_Types.Feet_per_Min is
    begin
        return Air_Data_Computer.Get_VVI(CNT.This_Subsystem.The_Primary_adc);
    end Primary_vvi;

    function Primary_Ias return Length_Types.Knots is
    begin
        return Air_Data_Computer.Indicated_Airspeed(CNT.This_Subsystem.The_Primary_adc);
    end Primary_ias;

    function Max_Operating_Airspeed return Length_Types.Knots is
    begin
        return Air_Data_Computer.Maximum_Operating_Airspeed(CNT.This_Subsystem.The_Primary_adc);
    end Max_Operating_Airspeed;

    function Primary_Ind_Mach return Length_Types.Mach is
    begin
        return Air_Data_Computer.Indicated_Mach_Number(CNT.This_Subsystem.The_Primary_Adc);
    end Primary_Ind_Mach;

    function Overspeed_Warning return Boolean is
    begin
        return Air_Data_Computer.Overspeed_Warning(CNT.This_Subsystem.The_Primary_Adc);
    end Overspeed_Warning;

--| Standby Instruments Air Data Computer
    function Standby_Alt return Length_Types.Feet is
    begin
       return Air_Data_Computer.Standby_Ind_Alt(CNT.This_Subsystem.The_Standby_adc);
    end Standby_Alt;

  function Standby_Ias return Length_Types.Knots is
    begin
        return Air_Data_Computer.Indicated_Airspeed(CNT.This_Subsystem.The_Standby_ADC);
    end Standby_IAs;

    function Pressure_Alt return Length_Types.Feet is
    begin
        return Air_Data_Computer.Pressure_Altitude(CNT.This_Subsystem.The_Primary_adc);
    end Pressure_Alt;

    function Packed_Pressure_Altitude return Arinc_429_Types.Message_Type is
    begin
        return CNT.This_Arinc_Output.A429_Tx_Adc_203_Alt
          (Flight_Instruments_Arinc_Labels.Channel_A);
    end Packed_Pressure_Altitude;

    --| Slip_Indicator
--    function Ball_Pos return Flight_Instruments_Types.Slip_Indicator_Type is
--    begin
--        return Container.EADI_Slip_Indicator.Ball_Pos(CNT.This_Subsystem.The_EADI_Slip_Indicator);
--    end Ball_Pos;

    function Get_Standby_Turn_Indicator_Turn_Rate return Float is
    begin
        return Turn_Indicator.Get_Turn_Rate(CNT.This_Subsystem.The_Standby_Turn_Indicator);
    end Get_Standby_Turn_Indicator_Turn_Rate;

    --| The_Primary_Pitot_Probe_Heater
    function Get_Primary_Pitot_Probe_Heater_Is_On return Boolean is
    begin
        return Probe_Heater.Is_On(CNT.This_Subsystem.The_Primary_Pitot_Probe_Heater);
    end Get_Primary_Pitot_Probe_Heater_Is_On;

    function Get_Primary_Pitot_Probe_Heater_Load return Float is
    begin
        return Probe_Heater.Load(CNT.This_Subsystem.The_Primary_Pitot_Probe_Heater);
    end Get_Primary_Pitot_Probe_Heater_Load;

    --| The_Secondary_Pitot_Probe_Heater
    function Get_Secondary_Pitot_Probe_Heater_Is_On return Boolean is
    begin
        return Probe_Heater.Is_On(CNT.This_Subsystem.The_Secondary_Pitot_Probe_Heater);
    end Get_Secondary_Pitot_Probe_Heater_Is_On;

    function Get_Secondary_Pitot_Probe_Heater_Load return Float is
    begin
        return Probe_Heater.Load(CNT.This_Subsystem.The_Secondary_Pitot_Probe_Heater);
    end Get_Secondary_Pitot_Probe_Heater_Load;

    --| The_Angle_of_Attack_Pitot_Probe_Heater
    function Get_Angle_Of_Attack_Pitot_Probe_Heater_Is_On return Boolean is
    begin
        return Probe_Heater.Is_On(CNT.This_Subsystem.The_Angle_of_Attack_Probe_Heater);
    end Get_Angle_Of_Attack_Pitot_Probe_Heater_Is_On;

    function Get_Angle_of_Attack_Vane_Probe_Heater_Load return Float is
    begin
        return Probe_Heater.Load(CNT.This_Subsystem.The_Angle_of_Attack_Probe_Heater);
    end Get_Angle_of_Attack_Vane_Probe_Heater_Load;

    function Overspeed_warn return boolean is
    begin
        return CNT.This_Subsystem.Overspeed_warn;
    end Overspeed_warn;

    function Anti_Ice_Annunciator_Request return Boolean is
       package Ctnr  renames Container;
       package Ele   renames Jpats_Electrical;
       package Ele_T renames Jpats_Electrical_Types;
       Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
    begin
       return (Io.Probes_Anti_Ice_On_Sw and Ele.Is_Powered (Ele_T.Aoa_Ht_Cb));
    end Anti_Ice_Annunciator_Request;

    function Stick_Shaker_Is_Active  return Boolean is
    begin
       return CNT.This_IO_Interface.Shaker_On;
    end Stick_Shaker_Is_Active ;

    function debug1 return Float is
    begin
       return Container.This_Subsystem.debug1;
    end debug1;

    function debug2 return Float is
    begin
       return Container.This_Subsystem.debug2;
    end debug2;

     function debug3 return Float is
    begin
       return Container.This_Subsystem.debug3;
    end debug3;

      function debug4 return Float is
    begin
       return Container.This_Subsystem.debug4;
    end debug4;

    function debug5 return Float is
    begin
       return Container.This_Subsystem.debug5;
    end debug5;

    function debug6 return Float is
    begin
       return Container.This_Subsystem.debug6;
    end debug6;

end JPATS_Flight_Instruments;

