-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Flight_Instruments.Container;
with Probe_Heater;
with Jpats_Electrical;
with Jpats_Electrical_Types;

package body Jpats_Flight_Instruments.Probe_Heater_Controller is

   procedure Initialize
   is
      package Ctnr renames Container;
   begin
      Probe_Heater.Initialize (Ctnr.This_Subsystem.The_Primary_Pitot_Probe_Heater);
      Probe_Heater.Initialize (Ctnr.This_Subsystem.The_Secondary_Pitot_Probe_Heater);
      Probe_Heater.Initialize (Ctnr.This_Subsystem.The_Angle_of_Attack_Probe_Heater);
   end Initialize;

   procedure Update
     (Iconst : in Float)
   is
      package Ctnr  renames Container;
      package Ph    renames Probe_Heater;
      package Ele   renames Jpats_Electrical;
      package Ele_T renames Jpats_Electrical_Types;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      The_Left_Ph  : Ph.Instance renames Ctnr.This_Subsystem.The_Secondary_Pitot_Probe_Heater;
      The_Right_Ph : Ph.Instance renames Ctnr.This_Subsystem.The_Primary_Pitot_Probe_Heater;
      The_Aoa_Ph   : Ph.Instance renames Ctnr.This_Subsystem.The_Angle_Of_Attack_Probe_Heater;
      Left_Probe_Pwr  : constant Boolean := Io.Probes_Anti_Ice_On_Sw and Ele.Is_Powered (Ele_T.Pitot_Ht_Cb);
      Right_Probe_Pwr : constant Boolean := Io.Probes_Anti_Ice_On_Sw and Ele.Is_Powered (Ele_T.Pitot_Ht_Cb);
      Aoa_Probe_Pwr   : constant Boolean := Io.Probes_Anti_Ice_On_Sw and Ele.Is_Powered (Ele_T.Aoa_Ht_Cb);
   begin

      -- the left probe
      Ph.Update (The_Left_Ph, Left_Probe_Pwr);

      -- The Right Probe
      Ph.Update (The_Right_Ph, Right_Probe_Pwr);

      -- the aoa probe
      Ph.Update (The_Aoa_Ph, Aoa_Probe_Pwr);

   end Update;

end Jpats_Flight_Instruments.Probe_Heater_Controller;

