-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Flight_instruments.Container;
with Jpats_Ios_Interface;
with System;

package body Jpats_Flight_instruments.Ios_Interface is

   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   package JII renames Jpats_Ios_Interface;

   procedure Adc_fail (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Adc_fail := JII.Convert_To_Bool(PData);
   end Adc_fail;

   procedure Pitot_block (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Pitot_block := JII.Convert_To_Bool(PData);
   end Pitot_block;

   procedure Static_block (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Static_block := JII.Convert_To_Bool(PData);
   end Static_block;

   procedure Shaker_Fail_On (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Stick_Shaker_On:= JII.Convert_To_Bool(PData);
   end Shaker_Fail_On;

end Jpats_Flight_instruments.Ios_Interface;
