-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--
with Jpats_Flight_instruments.Container;
with Jpats_Ios_Interface;
with Jpats_Flight_instruments.Ios_Interface;

separate (Jpats_Flight_instruments.Controller)

  procedure Register_Ios_Variables is

  begin

     Jpats_Ios_Interface.Register
       ( Name        => "MFAV03",
         Variable    => Container.This_Ios_Interface.static_block'Address,
         Set_Routine => Jpats_Flight_Instruments.Ios_Interface.Static_block'Access
         );

     Jpats_Ios_Interface.Register
       ( Name        => "MFAV04",
         Variable    => Container.This_Ios_Interface.pitot_block'Address,
         Set_Routine => Jpats_Flight_Instruments.Ios_Interface.pitot_block'Access
         );

     Jpats_Ios_Interface.Register
       ( Name        => "MFAV06",
         Variable    => Container.This_Ios_Interface.Adc_fail'Address,
         Set_Routine => Jpats_Flight_Instruments.Ios_Interface.Adc_fail'Access
         );

     Jpats_Ios_Interface.Register
       ( Name        => "MFFC09",
         Variable    => Container.This_Ios_Interface.Stick_Shaker_On'Address,
         Set_Routine => Jpats_Flight_Instruments.Ios_Interface.Shaker_Fail_On'Access
         );

     Jpats_Ios_Interface.Register
       ( Name        => "aoa test switch",
         Variable    => Container.This_Ios_Interface.aoa_test_sw'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "aoa indexer",
         Variable    => Container.This_Ios_Interface.aoa_indexer'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "EADI_Slip_Ball",
         Variable    => Container.This_Ios_Interface.EADI_Slip_Ball'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "ind_mach",
         Variable    => Container.This_Ios_Interface.ind_mach'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "aoa_units",
         Variable    => Container.This_Ios_Interface.aoa_units'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "ias lim",
         Variable    => Container.This_Ios_Interface.ias_lim'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "nz",
         Variable    => Container.This_Ios_Interface.nz'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "baro set hg",
         Variable    => Container.This_Ios_Interface.baro_set'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "baro set mb",
         Variable    => Container.This_Ios_Interface.baro_set_mb'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "rate of climb",
         Variable    => Container.This_Ios_Interface.rate_of_climb'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "oat-deg C",
         Variable    => Container.This_Ios_Interface.oat_deg'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "ias",
         Variable    => Container.This_Ios_Interface.ias'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "True_Hgd",
         Variable    => Container.This_Ios_Interface.True_Hdg'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "Mag_Hgd",
         Variable    => Container.This_Ios_Interface.Mag_Hdg'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "Ind_alt",
         Variable    => Container.This_Ios_Interface.Ind_altitude'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "Probes_Anti_Ice_On_Sw",
         Variable    => Container.This_Io_Interface.Probes_Anti_Ice_On_Sw'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "parameter_frz_on",
         Variable    => Container.This_Ios_Interface.Parameter_Frz_on'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "Overspeed_test",
         Variable    => Container.This_Io_Interface.Overspeed_Test'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "Asi_Power",
         Variable    => Container.This_Ios_Interface.Asi_Power'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "Alt_Power",
         Variable    => Container.This_Ios_Interface.Alt_Power'Address
         );

     Jpats_Ios_Interface.Register
       ( Name        => "Vsi_Power",
         Variable    => Container.This_Ios_Interface.Vsi_Power'Address
         );

  end Register_Ios_Variables;





