-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

separate (Jpats_Flight_instruments.Controller)

  procedure Register_Io_Variables is

  begin
--   arinc words output for glass instruments
   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_a_l203",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_203_Alt(a429.channel_a)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_203_Alt(a429.channel_a)'size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_b_l203",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_203_Alt(a429.channel_b)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_203_Alt(a429.Channel_b)'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_a_l205",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_205_Mach(a429.channel_a)'ADDRESS,
      A_Size          => A429_Out.A429_Tx_Adc_205_Mach(a429.channel_a)'size);

      Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_b_l205",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_205_Mach(a429.channel_b)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_205_Mach(a429.channel_b)'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_a_l206",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_206_IAS(a429.channel_a)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_206_IAS(a429.channel_a)'size);

     Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_b_l206",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_206_IAS(a429.channel_b)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_206_IAS(a429.channel_b)'size);

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_a_l207",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_207_Max_as(a429.channel_a)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_207_Max_as(a429.channel_A)'size);

     Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_b_l207",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_207_Max_as(a429.channel_b)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_207_Max_as(a429.channel_B)'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_a_l212",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_212_VVI(a429.channel_a)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_212_VVI(a429.channel_a)'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_adc_b_l212",
      A_Direction     => Iot.Output,
      An_Address      => A429_Out.A429_Tx_Adc_212_VVI(a429.channel_b)'Address,
      A_Size          => A429_Out.A429_Tx_Adc_212_VVI(a429.channel_b)'size);

--  outputs to drive mechanical instruments
    -- ball beneath glass ari
    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EADI_SLIP_BALL",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Eadi_Slip_Ball'Address,
      A_Size          => Container.This_Io_Interface.Eadi_Slip_Ball'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "STBY_IND_AIRSPEED",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Stdby_airspeed'Address,
      A_Size          => Container.This_Io_Interface.Stdby_airspeed'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "STBY_MAX_AIRSPEED",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Stdby_Max_os'Address,
      A_Size          => Container.This_Io_Interface.Stdby_Max_os'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "stby_altimeter_cosine",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Stdby_Alt_cos'Address,
      A_Size          => Container.This_Io_Interface.Stdby_Alt_cos'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "stby_altimeter_sine",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Stdby_Alt_sin'Address,
      A_Size          => Container.This_Io_Interface.Stdby_Alt_sin'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "TURN_SLIP_TURN_SIGNAL",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Stdby_Turn_Rate'Address,
      A_Size          => Container.This_Io_Interface.Stdby_Turn_Rate'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "TURN_SLIP_SLIP_SIGNAL",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Stdby_Slip_Ball'Address,
      A_Size          => Container.This_Io_Interface.Stdby_Slip_Ball'size);
--  power to glass vvi
    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "vvi_28vdc_pwr",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Vvi_pwr'Address,
      A_Size          => Container.This_Io_Interface.Vvi_pwr'size);
--  power to glass asi
    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "asi_28vdc_pwr",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.asi_pwr'Address,
      A_Size          => Container.This_Io_Interface.asi_pwr'size);
--  power to glass altimeter
    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "alt_28vdc_pwr",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.alt_pwr'Address,
      A_Size          => Container.This_Io_Interface.alt_pwr'size);
    --  aoa sin/cos
     Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aoa_cosine",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Aoa_cos'Address,
      A_Size          => Container.This_Io_Interface.Aoa_cos'size);

     Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aoa_sine",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Aoa_sin'Address,
      A_Size          => Container.This_Io_Interface.Aoa_sin'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aoa_indexer_hi",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Aoa_index_hi'Address,
      A_Size          => Container.This_Io_Interface.Aoa_index_hi'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aoa_indexer_mid",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Aoa_index_ok'Address,
      A_Size          => Container.This_Io_Interface.Aoa_index_ok'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aoa_indexer_lo",
      A_Direction     => Iot.Output,
      An_Address      => Container.This_Io_Interface.Aoa_index_lo'Address,
      A_Size          => Container.This_Io_Interface.Aoa_index_lo'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "accelerometer_drive",
      A_Direction     => Iot.output,
      An_Address      => Container.This_Io_Interface.Load_factor'Address,
      A_Size          => Container.This_Io_Interface.Load_factor'size);


         Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "turn_slip_flag",
      A_Direction     => Iot.output,
      An_Address      => Container.This_Io_Interface.Stdby_Turn_Slip_Flag'Address,
      A_Size          => Container.This_Io_Interface.Stdby_Turn_Slip_Flag'size);

 --

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aoa_low_test_sw",
      A_Direction     => Iot.input,
      An_Address      => Container.This_Io_Interface.Aoa_test_lo'Address,
      A_Size          => Container.This_Io_Interface.Aoa_test_lo'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "a0a_high_test_sw",
      A_Direction     => Iot.input,
      An_Address      => Container.This_Io_Interface.Aoa_test_hi'Address,
      A_Size          => Container.This_Io_Interface.Aoa_test_hi'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "stby_altimeter_coarse",
      A_Direction     => Iot.input,
      An_Address      => Container.This_Io_Interface.Altimeter_volts'Address,
      A_Size          => Container.This_Io_Interface.Altimeter_volts'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "parameter_freeze_on",
      A_Direction     => Iot.input,
      An_Address      => Container.This_Io_Interface.parameter_freeze_on'Address,
      A_Size          => Container.This_Io_Interface.parameter_freeze_on'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "audio_ovr_spd_test_sw",
      A_Direction     => Iot.input,
      An_Address      => Container.This_Io_Interface.Overspeed_Test'Address,
      A_Size          => Container.This_Io_Interface.Overspeed_test'size);


    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "plt_stick_shaker_pwr",
      A_Direction     => Iot.output,
      An_Address      => Container.This_Io_Interface.Shaker_on'Address,
      A_Size          => Container.This_Io_Interface.Shaker_on'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "PROBES_ANTI_ICE_ON_SW",
      A_Direction     => Iot.input,
      An_Address      => Container.This_Io_Interface.Probes_Anti_Ice_On_Sw'Address,
      A_Size          => Container.This_Io_Interface.Probes_Anti_Ice_On_Sw'size);


    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "PARAMETER_GREEN",
      A_Direction     => Iot.output,
      An_Address      => Container.This_Io_Interface.Parameter_Green'Address,
      A_Size          => Container.This_Io_Interface.Parameter_Green'size);

    Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "PARAMETER_AMBER",
      A_Direction     => Iot.output,
      An_Address      => Container.This_Io_Interface.Parameter_Amber'Address,
      A_Size          => Container.This_Io_Interface.Parameter_Amber'size);




  end Register_Io_Variables;
