-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Air_Data_Computer;
with Slip_Indicator;
with Turn_Indicator;
with Probe_Heater;
with Length_Types;
with Normalized_Types;
with Temperature_Types;
with JPATS_Flight_Instruments_Types;
with Flight_Instruments_Arinc_Labels;
with Arinc_429_Types;

package JPATS_Flight_Instruments.Container is

  package Standby_Slip_Indicator is new
    Slip_Indicator (Radius_Of_Curvature => Length_Types.Inches(3.717),
                    Ball_Diameter       => Length_Types.Inches(0.34),
                    Max_Ball_Travel     => Length_Types.Inches(0.675));

  package EADI_Slip_Indicator is new
    Slip_Indicator (Radius_Of_Curvature => Length_Types.Inches(3.47),
                    Ball_Diameter       => Length_Types.Inches(0.18),
                    Max_Ball_Travel     => Length_Types.Inches(0.36));

    type Instance is
      record
         The_Primary_Pitot_Probe_Heater    : Probe_Heater.Instance;
         The_Secondary_Pitot_Probe_Heater  : Probe_Heater.Instance;
         The_Angle_of_Attack_Probe_Heater  : Probe_Heater.Instance;
         The_Primary_Adc                   : Air_Data_computer.Instance;
         The_Standby_Adc                   : Air_Data_computer.Instance;
         The_Standby_Slip_Indicator        : Standby_Slip_Indicator.Instance;
         The_EADI_Slip_Indicator           : EADI_Slip_Indicator.Instance;
         The_Standby_Turn_Indicator        : Turn_Indicator.Instance;
         The_Formation_Indicated_Airspeed  : Air_Data_computer.Instance;
         Overspeed_Warn                    : Boolean := False;

         filt_Aoa                          : Float := 0.0;
         Ind_aoa                           : Float := 0.0;
         Old_Units                         : Float := 0.0;

         Debug1                        : Float := 1.0;
         Debug2                        : Float := 1.0;
         Debug3                        : Float := 1.0;
         Debug4                        : Float := 1.0;
         Debug5                        : Float := 1.0;
         Debug6                        : Float := 1.0;
      end record;

      This_Subsystem : Instance;

    type IOS_Interface_Instance is
        record
          --| Malfunctions
            Adc_Fail                     : Boolean;
            pitot_Block                  : Boolean;
            Static_Block                 : Boolean;
            Stick_Shaker_On              : Boolean;
         -- Repeater Instruments
            True_Hdg                     : Float;
            Mag_Hdg                      : Float;
            Ind_Mach                     : Float;
            Aoa_Units                    : Angle_Types.Degrees;
            Aoa_Indexer                  : Integer;
            Ias_Lim                      : Length_Types.Knots;
            Nz                           : Float;
            Baro_Set                     : Force_Types.Inches_of_Hg;
            Baro_Set_mb                  : Float;
            Rate_Of_Climb                : Length_Types.Feet_per_Min;
            Oat_Deg                      : Temperature_Types.Celsius;
            EADI_Slip_Ball               : Float;
            Ias                          : Length_Types.Knots;
            Ind_Altitude                 : Length_Types.Feet;
            Parameter_Frz_On             : Boolean;
            aoa_test_Sw                  : Integer := 0;
            Asi_Power                    : Boolean := False;
            Alt_Power                    : Boolean := False;
            Vsi_Power                    : Boolean := False;

        end record;

        This_IOS_Interface : IOS_Interface_Instance;

    type IO_Interface_Instance is
       record
--  outputs
            Eadi_Slip_Ball            : JPATS_Flight_Instruments_Types.Slip_Indicator_Type;
            Stdby_Airspeed            : Length_Types.Knots;
            Stdby_Max_Os              : Length_Types.Knots;
            Stdby_Alt_Cos             : Float;
            Stdby_Alt_sin             : float;
            Stdby_Turn_Rate           : Float;      --| Standby Turn Indicator
            Stdby_Slip_Ball           : Float;
            Vvi_Pwr                   : Boolean;
            Asi_Pwr                   : Boolean;
            Alt_Pwr                   : Boolean;

            AOA_Cos                   : Normalized_Types.Normalize;
            AOA_Sin                   : Normalized_Types.Normalize;
            AOA_Index_HI              : Boolean;
            AOA_Index_OK              : Boolean;
            AOA_Index_LO              : Boolean;
            Load_Factor               : Float;

            Stdby_Turn_Slip_Flag      : Boolean;
            Probes_Anti_Ice_On_Sw     : Boolean;

            Parameter_Green           : Boolean := True;   --do
            Parameter_Amber           : Boolean := False;  --do

 --  inputs
          AOA_Test_Hi               : Boolean;
          AOA_Test_lo               : Boolean;
          Altimeter_volts           : float;
          Aspd_Off_Flag             : Boolean;
          Shaker_On                 : Boolean;
          Parameter_Freeze_On       : Boolean;
          Overspeed_test            : Boolean;
        end record;

    for Io_Interface_Instance use
       record
            Eadi_Slip_Ball            at 004 range 0..31;
            Stdby_Airspeed            at 008 range 0..31;
            Stdby_Max_Os              at 012 range 0..31;
            Stdby_Alt_Cos             at 016 range 0..31;
            Stdby_Alt_sin             at 020 range 0..31;
            Stdby_Turn_Rate         at 024 range 0..31;
            Stdby_Slip_Ball         at 028 range 0..31;

            Vvi_Pwr                   at 032 range 0..31;
            Asi_Pwr                   at 036 range 0..31;
            Alt_Pwr                   at 040 range 0..31;

            AOA_Sin                   at 044 range 0..31;
            AOA_Cos                   at 048 range 0..31;
            AOA_Index_HI              at 052 range 0..31;
            AOA_Index_OK              at 056 range 0..31;
            AOA_Index_LO              at 060 range 0..31;

            Load_Factor               at 064 range 0..31;
            Stdby_Turn_Slip_Flag      at 068 range 0..31;
            Probes_Anti_Ice_On_Sw     at 072 range 0..31;

            Parameter_Green           at 076 range 0..31;
            Parameter_Amber           at 080 range 0..31;


            AOA_Test_Hi               at 084 range 0..31;
            AOA_Test_lo               at 088 range 0..31;
            Altimeter_volts           at 092 range 0..31;

            Aspd_Off_Flag             at 096 range 0..31;
            Shaker_On                 at 100 range 0..31;
            Parameter_Freeze_On       at 104 range 0..31;
            Overspeed_Test            at 108 range 0..31;
       end record;

    This_IO_Interface : IO_Interface_Instance;

    type Arinc_Array_Type is array
      (Flight_Instruments_Arinc_labels.FI_Bnr_Sdi_Type range Flight_Instruments_Arinc_Labels.Channel_A .. Flight_Instruments_Arinc_Labels.Channel_b) of Arinc_429_Types.Message_Type;

    type Arinc_Output_Instance is
       record
          A429_Tx_Adc_203_Alt        : Arinc_Array_Type;
          A429_Tx_Adc_205_Mach       : Arinc_Array_Type;
          A429_Tx_Adc_206_Ias        : Arinc_Array_Type;
          A429_Tx_Adc_207_Max_As     : Arinc_Array_Type;
          A429_Tx_Adc_212_Vvi        : Arinc_Array_Type;
    end record;

    This_Arinc_Output : Arinc_Output_Instance;

end JPATS_Flight_Instruments.Container;
