-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Yogesh Tupe
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Flight_Instruments.AOA_System_Controller;
with Scheduler_Collection;

package body JPATS_Flight_Instruments.AOA_System_Scheduler is

   procedure Initialize
     (An_Instance : in out Instance) is
   begin

      AOA_System_Controller.Initialize;

   end Initialize;

   procedure Update
     (An_Instance          : in out Instance;
      Integration_Constant : in     Float) is
   begin
      AOA_System_Controller.Update (dt => Integration_Constant);

   end Update;

   procedure Update_In_Freeze
     (An_Instance : in out Instance) is
   begin

           Update (An_Instance, 0.0);
   end Update_In_Freeze;

   -------------------------------------------------------------------------------
   -- Routine to save a snapshot of the instance to the given stream.
   --
   -- Note that the predefined attributes 'Write and 'Output can be used on any
   -- object to save its value to the given stream. This routine should be
   -- written so that data is written to the stream in the same order that it will
   -- be read back.
   -------------------------------------------------------------------------------
   procedure Save
     (An_Instance : in out Instance;
      To_Stream   : in out Ada.Streams.Root_Stream_Type'Class) is
   begin
      null;
   end Save;

   -------------------------------------------------------------------------------
   -- Routine to retrieve a snapshot of the instance from the given stream.
   --
   -- Note that the predefined attributes 'Read and 'Input can be used on any
   -- object to retrieve its value in the given stream. This routine should be
   -- written so that data is read from the stream in the same order it was placed
   -- into the stream.
   -------------------------------------------------------------------------------
   procedure Restore
     (An_Instance : in out Instance;
      From_Stream : in out Ada.Streams.Root_Stream_Type'Class) is
   begin
      null;
   end Restore;


   -- Declare an instance of this scheduler to be added to the collection.

   This_Scheduler : aliased Instance;

begin

   -- Note that the string argument is no longer required.  The name of the
   -- scheduler is extracted from the tag.

   Scheduler_Collection.Register
     (This_Scheduler'Access);

end JPATS_Flight_Instruments.AOA_System_Scheduler;

