-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Howard Landmann
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Arinc_429_Types;
with Arinc_429_Bnr;

package Flight_instruments_Arinc_Labels is

  --
  -- Ada LRM 13.2 describes Boolean types as always
  -- represented as 1 bit.  If any other types, i.e.
  -- enumerated types are used, a "For" Use" statement
  -- may be needed for the discrete type.  Otherwise,
  -- a simple pragma pack command should suffice.
  --
  type Fi_Bnr_Sdi_Type is
    ( Not_Used, Channel_A, Channel_B, Not_Used_3);

  package Label_203 is new Arinc_429_Bnr
    ( Label              => 8#203#,
      Value_Type         => Float,
      Scale              => 131072.0,
      Significant_Digits => 17,
      Sdi_Type           => fi_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_types.No_Discretes_Type );
 -- ********************************************************
  -- mach

  package Label_205 is new Arinc_429_Bnr
    ( Label              => 8#205#,
      Value_Type         => Float,
      Scale              => 4.096,
      Significant_Digits => 16,
      Sdi_Type           => fi_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_types.No_Discretes_Type );

  -- ********************************************************
    -- computed airspeed

  package Label_206 is new Arinc_429_Bnr
    ( Label              => 8#206#,
      Value_Type         => Float,
      Scale              => 1024.0,
      Significant_Digits => 14,
      Sdi_Type           => fi_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_types.No_Discretes_Type );

  -- ********************************************************
  -- max allowable airspeed

  package Label_207 is new Arinc_429_Bnr
    ( Label              => 8#207#,
      Value_Type         => Float,
      Scale              => 1024.0,
      Significant_Digits => 12,
      Sdi_Type           => fi_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_types.No_Discretes_Type );


  -- ********************************************************
  -- altitude rate (VVI)

  package Label_212 is new Arinc_429_Bnr
    ( Label              => 8#212#,
      Value_Type         => Float,
      Scale              => 32768.0,-- was 65536 for test
      Significant_Digits => 11,
      Sdi_Type           => fi_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_types.No_Discretes_Type );

end Flight_instruments_Arinc_Labels;







