-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Force_Types;
with Length_Types;
with Mass_Types;
with Flight_Instruments_Arinc_Labels;
with Arinc_429_Types;
with Temperature_Types;
with Interpolation_Table.Multiply_Indexed;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;

package Air_Data_Computer is

    type Instance is private;
    package It renames Interpolation_Table;

    procedure Set_Baro_Correction
        (Altimeter_Set         :in      Force_Types.Inches_of_Hg;
         An_Instance           :in out  Instance);

    function Get_Baro_Correction (An_Instance :in Instance)
                  return Length_Types.Feet;

    procedure Compute_Sensed_Static_Pressure
                     (Pressure    : in     Force_Types.Pounds_per_Sq_Feet;
                      Lag         : in     Float;
                      An_Instance : in out Instance);

    procedure Compute_Sensed_pitot_Pressure
    --  (true_mach    : in     Float;
                     (Dyn_Press    : in     Force_Types.Pounds_per_Sq_Feet;
                      True_Static  : in     Force_Types.Pounds_per_Sq_Feet;
                      blockage     : in     Float;
                      An_Instance  : in out Instance);

    procedure Compute_Pressure_Altitude
        (Pressure        : in  Force_Types.Pounds_per_Sq_Feet;
         An_Instance     : in out Instance);

    procedure Compute_sensed_Altitude
        (An_Instance     : in out Instance);


    procedure Compute_primary_Ind_alt
        (Flap_Pos           :in     Angle_Types.Degrees;
         DHPADC_Table       :in out IT.Multiply_Indexed.Instance;
         An_Instance        :in out Instance);

    procedure Compute_Standby_Ind_alt
        (Flap_Pos           :in     Angle_Types.Degrees;
         Flap_Effect_T      :in out IT.Multiply_Indexed.Instance;
         An_Instance        :in out Instance);

    function Standby_Ind_Alt (An_Instance :in Instance)
                        return Length_Types.Feet;

    function Primary_Ind_Alt(An_Instance :in Instance)
                        return Length_Types.Feet;

    procedure Calc_vvi(Dt            :in     Float;
                       An_Instance   :in out Instance);

    function Get_VVI (An_Instance :in Instance)
                 return Length_Types.Feet_per_Min;

    --| Raytheon's model for Mach, Ias, Maximum_Operating_speed
    procedure calc_Primary_Ias
        (Flap_Pos            :in     Angle_Types.Degrees;
         Gear_Up             :in    Boolean;
         Air_Dens            :in     Mass_Types.Slugs_per_Cubic_Feet;
         Oat                 :in     Temperature_Types.Rankine;
         Yaw_Rate            :in     Angle_Types.Radians_Per_Sec;
         Alpha               :in     Float;
         VKIASADC_T          :in out IT.Doubly_Indexed.Instance;
         An_Instance         :in out Instance);

    --|  FSI's Math model for Standby Flight Instruments
    procedure calc_Standby_IAS
        (Flap_Pos            :in     Angle_Types.Degrees;
         Gear_Up             :in     Boolean;
         Side_Slip_Angle     :in     Angle_Types.Radians;
         Air_Dens            :in     Mass_Types.Slugs_per_Cubic_Feet;
         Yaw_Rate            :in     Angle_Types.Radians_Per_Sec;
         CAS_T               :in out IT.Doubly_Indexed.Instance;
         mach_T              :in out IT.Doubly_Indexed.Instance;
         An_Instance         :in out Instance);

   function Indicated_Airspeed (An_Instance :in Instance)
                     return Length_Types.Knots;
   function Maximum_Operating_Airspeed (An_Instance :in Instance)
                     return Length_Types.Knots;
   function Indicated_Mach_Number (An_Instance :in Instance)
                     return Length_Types.Mach;
   function Overspeed_Warning (An_Instance :in Instance) return Boolean;
   function pressure_Altitude  (An_Instance :in Instance)
      return Length_Types.Feet;
   procedure Calc_Label_203(Tx_203_Alt     :     out Arinc_429_Types.Message_type;
                            Channel        : in     Flight_instruments_Arinc_Labels.Fi_Bnr_Sdi_Type;
                            Adc_off        : in     Boolean;
                            An_Instance    : in     instance);

   procedure Calc_Label_205(Tx_205_mach    :     out Arinc_429_Types.Message_type;
                            Channel        : in     Flight_instruments_Arinc_Labels.Fi_Bnr_Sdi_Type;
                            Adc_off        : in     Boolean;
                            An_Instance    : in     instance);

   procedure Calc_Label_206(Tx_206_ias     :     out Arinc_429_Types.Message_type;
                            Channel        : in     Flight_instruments_Arinc_Labels.Fi_Bnr_Sdi_Type;
                            Adc_off        : in     Boolean;
                            An_Instance    : in     instance);

   procedure Calc_Label_207(Tx_207_Max_as  :     out Arinc_429_Types.Message_type;
                            Channel        : in     Flight_instruments_Arinc_Labels.Fi_Bnr_Sdi_Type;
                            Adc_off        : in     Boolean;
                            An_Instance    : in     instance);

   procedure Calc_Label_212(Tx_212_vvi     :     out Arinc_429_Types.Message_type;
                            Channel        : in     Flight_instruments_Arinc_Labels.Fi_Bnr_Sdi_Type;
                            Adc_off        : in     Boolean;
                            An_Instance    : in     instance);
   procedure Scale_Airspeed(Sb_Ias_t       :in out IT.singly_Indexed.Instance;
                            An_Instance    :in out Instance);
   function Scaled_Max_AS(An_Instance :in Instance) return Float;
   function scaled_As(An_Instance :in Instance) return Float;

   procedure Stdby_Alt_Drive (Volts           :in     Float;
                              Sb_Alt_T        :in out IT.singly_Indexed.Instance;
                              An_Instance     :in out Instance);
   function Stdby_sin (An_Instance :in Instance) return float;
   function Stdby_cos (An_Instance :in Instance) return float;

private
    type Instance is
        record
           The_Baro_Correction          : Float := 0.0;
           The_pressure_Altitude        : Length_Types.Feet := 0.0;
           The_Sensed_Altitude          : Length_Types.Feet := 0.0;
           The_Old_Sensed_Altitude      : Length_Types.Feet := 0.0;
           The_Indicated_Altitude       : Length_Types.Feet := 0.0;
           Command_Ind                  : Length_Types.Feet := 0.0;
           The_Vvi                      : Length_Types.Feet_per_Min := 0.0;
           The_Indicated_Airspeed       : Length_Types.Knots := 0.0;
           adc_Mach_Number              : Length_Types.Mach := 0.0;
           The_Indicated_Mach_Number    : Length_Types.Mach := 0.0;
           The_Max_Operating_Airspeed   : Length_Types.Knots := 316.0;
           The_Overspeed_Aural_Warning  : Boolean := false;
           Sensed_Static_Press          : Force_types.Pounds_per_Sq_Feet;
           Sensed_Pitot_press           : Force_types.Pounds_per_Sq_Feet;
           Sensed_total_press           : Force_types.Pounds_per_Sq_Feet;
           The_Scaled_Ias               : float := -10.0;  -- 0 kt
           The_Scaled_Max_As            : Float := 10.0;   --316 kt
           Stdby_Sin                    : Float := 0.0;
           Stdby_Cos                    : Float := 0.0;
           Old_Alt_Volts                : Float := 0.0;
           Alt_Safety                   : Boolean := False;
        end record;
end Air_Data_Computer;





