-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Thermal_Time_Delay_G is

   function Is_Open
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Open;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Open()");
         raise;
   end Is_Open;

   function Is_Closed
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Closed;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Closed()");
         raise;
   end Is_Closed;

   procedure Close
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Closed;
   exception
      when others =>
         Log.Report(Package_Name & ".Close()");
         raise;
   end Close;

   procedure Open
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Open;
   exception
      when others =>
         Log.Report(Package_Name & ".Open()");
         raise;
   end Open;

   procedure Update
     (An_Instance : in out Instance;
      Value       : in     Sensed_Type)
   is
   begin
      if Value = 0.0  and Is_Open (An_Instance) then
         Close (An_Instance);
      elsif Value = 1.0 and Is_Closed (An_Instance) then
         Open (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

end Thermal_Time_Delay_G;

