-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Solenoid_Dump_Valve_G is

   procedure Open
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Open;
      An_Instance.Load  := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Open()");
         raise;
   end Open;

   procedure Close
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Closed;
      An_Instance.Load  := Valve_Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Close()");
         raise;
   end Close;

   function State
     (An_Instance : in Instance)
     return State_Type
   is
   begin
      return An_Instance.State;
   exception
      when others =>
         Log.Report(Package_Name & ".State()");
         raise;
   end State;

   function Load
     (An_Instance : in Instance)
     return Current_Type
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;


   function Is_Open
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Open;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Open()");
         raise;
   end Is_Open;

   function Is_Closed
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Closed;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Closed()");
         raise;
   end Is_Closed;

   procedure Update
     (An_Instance : in out Instance;
      Power_In    : in     Boolean)
   is
   begin
      if Power_In and Is_Open (An_Instance) then
         Close (An_Instance);
      elsif not Power_In and Is_Closed (An_Instance) then
         Open (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Open;
      An_Instance.Load  := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end initialize;

end Solenoid_Dump_Valve_G;
