-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Safety_Valve_G is


   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Position := 0.0;
      An_Instance.Area     := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;


   procedure Open
     (An_Instance : in out Instance;
      Amount      : in     float)
   is
   begin
      if Float(Position_Type'Last - An_Instance.Position) <= Amount then
         An_Instance.Position := Position_Type'Last;
      else
         An_Instance.Position := Position_Type(Float(An_Instance.Position) + Amount);
      end if;
      An_Instance.Area := Area_Type (An_Instance.Position) * Area_Type (0.7);
   exception
      when others =>
         Log.Report(Package_Name & ".Open()");
         raise;
   end Open;

   procedure Close
     (An_Instance : in out Instance;
      Amount      : in     float)
   is
   begin
      if Float(An_Instance.Position - Position_Type'First) <= Amount then
         An_Instance.Position := Position_Type'First;
      else
         An_Instance.Position := Position_Type(Float(An_Instance.Position) - Amount);
      end if;
      An_Instance.Area := Area_Type (An_Instance.Position) * Area_Type (0.7);
   exception
      when others =>
         Log.Report(Package_Name & ".Close()");
         raise;
   end Close;

   function Position
     (An_Instance : in Instance)
     return Position_Type
   is
   begin
      return An_Instance.Position;
   exception
      when others =>
         Log.Report(Package_Name & ".Position()");
         raise;
   end Position;

   function Area
     (An_Instance : in Instance)
     return Area_Type
   is
   begin
      return An_Instance.Area;
   exception
      when others =>
         Log.Report(Package_Name & ".Area()");
         raise;
   end Area;

end Safety_Valve_G;



