-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


generic
   type Current_Type is digits <>;
   High_Flow_Load   : in Current_Type;
   Normal_Flow_Load : in Current_Type;
   Package_Name : in String;

package Ram_Air_Valve_G is

   type Instance is private;

   procedure Update
     (An_Instance : in out Instance;
      High_In     : in     Boolean;
      Norm_In     : in     Boolean;
      Close_In    : in     Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

   function Is_High
     (An_Instance : in Instance)
     return Boolean;

   function Is_Norm
     (An_Instance : in Instance)
     return Boolean;

   function Is_Closed
     (An_Instance : in Instance)
     return Boolean;

   function Load
     (An_Instance : in Instance)
     return Current_Type;

private

   type State_Type is (High_Flow, Normal_Flow, Closed);

   type Instance is
      record
         State : State_Type;
         Load  : Current_Type;
      end record;

end Ram_Air_Valve_G;
