-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Ram_Air_Valve_G is

   procedure High_Flow
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := High_Flow;
      An_Instance.Load  := High_Flow_Load;
   exception
      when others =>
         Log.Report(Package_Name & ".High_Flow()");
         raise;
   end High_Flow;

   procedure Normal_Flow
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Normal_Flow;
      An_Instance.Load  := Normal_Flow_Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Normal_Flow()");
         raise;
   end Normal_Flow;

   procedure Close
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Closed;
      An_Instance.Load  := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Close()");
         raise;
   end Close;

   function State
     (An_Instance : in Instance)
     return State_Type
   is
   begin
      return An_Instance.State;
   exception
      when others =>
         Log.Report(Package_Name & ".State()");
         raise;
   end State;

   function Is_High
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = High_Flow;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_High()");
         raise;
   end Is_High;

   function Is_Norm
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Normal_Flow;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Norm()");
         raise;
   end Is_Norm;

   function Is_Closed
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Closed;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Closed()");
         raise;
   end Is_Closed;

   function Load
     (An_Instance : in Instance)
     return Current_Type
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;

   procedure Update
     (An_Instance : in out Instance;
      High_In     : in     Boolean;
      Norm_In     : in     Boolean;
      Close_In    : in     Boolean)
   is
   begin
      if Close_In and not Is_Closed (An_Instance) then
         Close (An_Instance);
      elsif Norm_In and not Is_Norm (An_Instance) then
         Normal_Flow (An_Instance);
      elsif High_In and not Is_High (An_Instance) then
         High_Flow (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Closed;
      An_Instance.Load  := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

end Ram_Air_Valve_G;
