-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Pneumatic_Regulator_G is

   procedure Update
     (An_Instance : in out Instance;
      Pressure_In : in     Pressure_Type)
   is
   begin
      if Pressure_In <= Regulated_Pressure then
         An_Instance.Pressure := Pressure_In;
      elsif Pressure_In > Regulated_Pressure then
         An_Instance.Pressure := Regulated_Pressure;
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Pressure := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Pressure
     (An_Instance : in Instance)
     return Pressure_Type
   is
   begin
      return An_Instance.Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure()");
         raise;
   end Pressure;

end Pneumatic_Regulator_G;
