-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


generic
   type Position_Type is digits <>;
   type Area_Type is digits <>;
   type Roc_Error_Type is digits <>;
   Package_Name : in String;
package Outflow_Valve_G is
   type Instance is private;
   procedure Open
     (An_Instance : in out Instance;
      Amount      : in     float);
   procedure Close
     (An_Instance : in out Instance;
      Amount      : in     float);
   procedure Modulate
     (An_Instance : in out Instance;
      Roc_Error   : in     Roc_Error_Type);
   function Position
     (An_Instance : in Instance)
      return Position_Type;
   function Area
     (An_Instance : in Instance)
      return Area_Type;
   procedure Update
     (An_Instance : in out Instance;
      Iconst      : in     Float;
      Roc_Error   : in     Roc_Error_Type);
   procedure Read_Tables;
   procedure Initialize
     (An_Instance : in out Instance);
private
   type Instance is
      record
         Position : Position_Type;
         Area     : Area_Type;
      end record;
end Outflow_Valve_G;
