-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


generic
   type Pressure_Type is digits <>;
   type Current_Type is digits <>;
   Package_Name : in String;
package Obogs_Regulator_G is

   type Instance is private;

   procedure Update
     (An_Instance               : in out Instance;
      Pressure_In               : in     Pressure_Type;
      Power_In                  : in     Boolean;
      Supply_Sw_On              : in     Boolean;
      Pressure_Cntrl_Sw_Normal  : in     Boolean;
      Pressure_Cntrl_Sw_Emerg   : in     Boolean;
      Concentration_Sw_Normal   : in     Boolean;
      Bit_Sw_In                 : in     Boolean;
      Bit_In                    : in     Boolean;
      O2_Sel_In                 : in     Boolean;
      Max_Light_In              : in     Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

   function Pressure
     (An_Instance : in Instance)
      return Pressure_Type;

   function Power_Out
     (An_Instance : in Instance)
     return Boolean;

   function Bit_Out
     (An_Instance : in Instance)
     return Boolean;

   function O2_Sel_Out
     (An_Instance : in Instance)
     return Boolean;

   function Max_Light
     (An_Instance : in Instance)
     return Boolean;

   function Load
     (An_Instance : in Instance)
     return Current_Type;

private

   type Instance is
      record
         Pressure   : Pressure_Type;
         Power_Out  : Boolean;
         Bit_Out    : Boolean;
         O2_Sel_Out : Boolean;
         Max_Light  : Boolean;
         Load       : Current_Type;
      end record;

end Obogs_Regulator_G;
