-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Obogs_Regulator_G is

   procedure Update
     (An_Instance               : in out Instance;
      Pressure_In               : in     Pressure_Type;
      Power_In                  : in     Boolean;
      Supply_Sw_On              : in     Boolean;
      Pressure_Cntrl_Sw_Normal  : in     Boolean;
      Pressure_Cntrl_Sw_Emerg   : in     Boolean;
      Concentration_Sw_Normal   : in     Boolean;
      Bit_Sw_In                 : in     Boolean;
      Bit_In                    : in     Boolean;
      O2_Sel_In                 : in     Boolean;
      Max_Light_In              : in     Boolean)
   is
      Pressure   : Pressure_Type renames An_Instance.Pressure;
      Power_Out  : Boolean       renames An_Instance.Power_Out;
      Bit_Out    : Boolean       renames An_Instance.Bit_Out;
      O2_Sel_Out : Boolean       renames An_Instance.O2_Sel_Out;
      Max_Light  : Boolean       renames An_Instance.Max_Light;
      Load       : Current_Type  renames An_Instance.Load;
   begin

      if Pressure_In > 0.0 then

         if Pressure_Cntrl_Sw_Normal then -- normal selected
              if Pressure_In > 0.072182 then
                 Pressure := 0.072182; -- psi (Supposed to be pilot demanded psi. Set here to be 2 inH2O.)
              else
                 Pressure := Pressure_In;
              end if;
         elsif Pressure_Cntrl_Sw_Emerg then --emergency selected
              if Pressure_In > 0.108273 then
                 Pressure := 0.108273; -- psi ( = 3 inH2O)
              else
                 Pressure := Pressure_In;
              end if;
         else --test mask selected
            if Pressure_In > 0.39700 then
               Pressure := 0.39700; -- psi ( = 11 inH2O)
            else
               Pressure := Pressure_In;
            end if;
         end if;

      else
         Pressure := 0.0; --psi
      end if;

      Power_Out := Power_In and Supply_Sw_On;

      Bit_Out := Bit_In and Bit_Sw_In;

      O2_Sel_Out := O2_Sel_In and Concentration_Sw_Normal;

      Max_Light := Max_Light_In and not Concentration_Sw_Normal;

      if Power_Out then Load := 3.0; else Load := 0.0; end if;

   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Pressure   := 0.0;
      An_Instance.Power_Out  := False;
      An_Instance.Bit_Out    := False;
      An_Instance.O2_Sel_Out := False;
      An_Instance.Max_Light  := False;
      An_Instance.Load       := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Power_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Power_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Power_Out()");
         raise;
   end Power_Out;

   function Bit_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Bit_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Bit_Out()");
         raise;
   end Bit_Out;

   function O2_Sel_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.O2_Sel_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".O2_Sel_Out()");
         raise;
   end O2_Sel_Out;

   function Max_Light
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Max_Light;
   exception
      when others =>
         Log.Report(Package_Name & ".Max_Light()");
         raise;
   end Max_Light;

   function Pressure
     (An_Instance : in Instance)
     return Pressure_Type
   is
   begin
      return An_Instance.Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure()");
         raise;
   end Pressure;

   function Load
     (An_Instance : in Instance)
     return Current_Type
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;


end Obogs_Regulator_G;
