-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic

   type Oxygen_Concentration_Type is digits <>;
   type Pressure_Type is digits <>;
   type Altitude_Type is digits <>;
   type Current_Type is digits <>;
   Package_Name : in String;
package Obogs_Concentrator_G is

   type Instance is private;

   procedure Update
     (An_Instance        : in out Instance;
      Iconst             : in     Float;
      Power_Available    : in     Boolean;
      Bit_In             : in     Boolean;
      Cockpit_Altitude   : in     Altitude_Type;
      Air_Available      : in     Boolean;
      Left_Wow_Sw        : in     Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

   function Oxygen_Concentration
     (An_Instance : in Instance)
      return Oxygen_Concentration_Type;

   function Pressure
     (An_Instance : in Instance)
      return Pressure_Type;

   function Obogs_Fail_Warn
     (An_Instance : in Instance)
     return Boolean;

   function Bit_Out
     (An_Instance : in Instance)
     return Boolean;

   function O2_Sel_Out
     (An_Instance : in Instance)
     return Boolean;

   function Load
     (An_Instance : in Instance)
     return Current_Type;

private

   type State_Type is (Off,Power_Up,Normal,Ibit,Mbit);

   type Instance is
      record
         Is_Powered           : Boolean;
         Is_Powered_Last_Pass : Boolean;
         Powered_Clock        : Float;
         Oxygen_Concentration : Oxygen_Concentration_Type;
         Pressure             : Pressure_Type;

         Obogs_Fail_Warn      : Boolean;

         State                : State_Type;
         PUB_Test_Clock       : Float;
         O2_Sensor_Test_Clock : Float;
         BIT_In_Clock         : Float;
         Ibit_Test_Clock      : Float;
         Mbit_Test_1_Clock    : Float;
         Mbit_Test_2_Clock    : Float;

         BIT_In_Last_Pass : Boolean;

         PUB_Test_Status      : Boolean;
         O2_Sensor_Test_Status : Boolean;
         Ibit_Test_Status      : Boolean;
         Mbit_Test_1_Status    : Boolean;
         Mbit_Test_2_Status    : Boolean;

         Bit_Out    : Boolean;
         O2_Sel_Out : Boolean;

         Load : Current_Type;

         State_Lp : State_Type := Off;
      end record;

end Obogs_Concentrator_G;
