-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Electrical_Units_Types;
with Jpats_Environmental_Types;
with Torque_Types;
with Mass_Types;

package Jpats_Environmental is

   function Is_Closed
     (Name : in Jpats_Environmental_Types.Relay_Name_Type)
      return Boolean;
   function Is_Open
     (Name : in Jpats_Environmental_Types.Relay_Name_Type)
      return Boolean;
   function Load
     (Name : in Jpats_Environmental_Types.Relay_Name_Type)
      return Electrical_Units_Types.Amps;

   function CANOPY_Annunciator_Request     return Boolean;
   function CKPT_ALT_Annunciator_Request   return Boolean;
   function CKPT_PX_Annunciator_Request    return Boolean;
   function DUCT_TEMP_Annunciator_Request  return Boolean;
   function OBOGS_FAIL_Annunciator_Request return Boolean;
   function OBOGS_TEMP_Annunciator_Request return Boolean;

-- function Bleed_Load

   function Canopy_Fractured                    return Boolean;
   function Canopy_Latched                      return Boolean;
   function Seat_Ejected                        return Boolean;

   function Anti_Gravity_Shutoff_Valve_Load     return Electrical_Units_Types.Amps;

   function Bi_Level_Flow_Control_Valve_Load    return Electrical_Units_Types.Amps;
   function Bleed_Air_Bypass_Valve_Load         return Electrical_Units_Types.Amps;

   function Canopy_Seal_Valve_Load              return Electrical_Units_Types.Amps;

   function Cockpit_Temperature_Controller_Load return Electrical_Units_Types.Amps;
   function Condensor_Blower_Load               return Electrical_Units_Types.Amps;
   function Evaporator_Blower_Load              return Electrical_Units_Types.Amps;
   function Heat_Exchanger_Blower_Load          return Electrical_Units_Types.Amps;

   function OBOGS_Concentrator_Load             return Electrical_Units_Types.Amps;
   function OBOGS_Regulator_Load                return Electrical_Units_Types.Amps;
   function OBOGS_Shutoff_Valve_Load            return Electrical_Units_Types.Amps;
   function Ram_Air_Valve_Load                  return Electrical_Units_Types.Amps;
   function Seat_Motor_Load                     return Electrical_Units_Types.Amps;


   -- for pwrplnt
   function Air_Conditioner_Compressor_Torque return Torque_Types.Ft_Lbf;
   function Bleed_Air_On                      return Boolean;
   function Bleed_Flow                        return Mass_Types.Ppm;

   -- for edm
   function Ckpt_Alt return Float;
   function Diff_Px return Float;


   -- for ios
   function Manual_Cold_Selected return Boolean;


   -- sound
   function Canopy_Position return Float;
   function Differential_Pressure return Float;
   function Pressure_System_Running return Float;
   function Air_Conditioning_System_Running return Float;
   function Windshield_Defrost_On return Float;
   function Explosive_Decompression return Float;


   -- freeze request
   function Freeze_Req return Boolean;

   --system resets
   procedure Reset_Ejection_Seat;
   procedure Reset_Canopy; --(fracture)

end Jpats_Environmental;




