-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with jpats_Environmental.Seat_Controller;
with Jpats_Environmental.Container;
with Log;

package body Jpats_Environmental is

   function Is_Closed
     (Name : in Jpats_Environmental_Types.Relay_Name_Type)
     return Boolean
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relay_Collection;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Relays;
   begin
      return Relays.Is_Closed (The_Relays, Name);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Is_Closed()");
         raise;
   end Is_Closed;

   function Is_Open
     (Name : in Jpats_Environmental_Types.Relay_Name_Type)
     return Boolean
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relay_Collection;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Relays;
   begin
      return Relays.Is_Open (The_Relays, Name);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Is_Open()");
         raise;
   end Is_Open;

   function CKPT_PX_Annunciator_Request  -- EDM
     return Boolean
   is
   begin
      return Boolean'First;
   exception
      when others =>
         Log.Report("Jpats_Environmental.CKPT_PX_Annunciator_Request()");
         raise;
   end CKPT_PX_Annunciator_Request;

   function CANOPY_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   begin
      return not Ctnr.Canopy.Is_Latched (Ctnr.This_Subsystem.The_Canopy) or Ios.Canopy_Annun_Malf;
   exception
      when others =>
         Log.Report("Jpats_Environmental.CANOPY_Annunciator_Request()");
         raise;
   end CANOPY_Annunciator_Request;

   function OBOGS_FAIL_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return (Ctnr.Concentrator.Obogs_Fail_Warn (Ctnr.This_Subsystem.The_Obogs_Concentrator) or
              Ctnr.Obogs_Low_Pressure_Switch.Is_Closed (Ctnr.This_Subsystem.The_Obogs_Low_Pressure_Switch));
   exception
      when others =>
         Log.Report("Jpats_Environmental.OBOGS_FAIL_Annunciator_Request()");
         raise;
   end OBOGS_FAIL_Annunciator_Request;

   function CKPT_ALT_Annunciator_Request -- EDM
     return Boolean
   is
   begin
      return Boolean'First;
   exception
      when others =>
         Log.Report("Jpats_Environmental.CKPT_ALT_Annunciator_Request()");
         raise;
   end CKPT_ALT_Annunciator_Request;

   function OBOGS_TEMP_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;
      package Env_T renames Jpats_Environmental_Types;
      package Relays renames Ctnr.Relay_Collection;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Relays;
   begin
      return (Relays.Is_Closed (The_Relays, Env_T.Obogs_Duct_Temp_Sense_Relay) and
              Ctnr.Obogs_High_Temperature_Switch.Is_Closed (Ctnr.This_Subsystem.The_Obogs_High_Temperature_Switch));
   exception
      when others =>
         Log.Report("Jpats_Environmental.OBOGS_TEMP_Annunciator_Request()");
         raise;
   end OBOGS_TEMP_Annunciator_Request;

   function DUCT_TEMP_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Ac_Over_Temp_Sw.Is_Closed (Ctnr.This_Subsystem.The_Ac_Over_Temp_Switch);
   exception
      when others =>
         Log.Report("Jpats_Environmental.DUCT_TEMP_Annunciator_Request()");
         raise;
   end DUCT_TEMP_Annunciator_Request;

   function Load
     (Name : in Jpats_Environmental_Types.Relay_Name_Type)
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relay_Collection;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Relays;
   begin
      return Relays.Load (The_Relays, Name);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Load()");
         raise;
   end Load;

   function Canopy_Fractured
     return Boolean
   is
      package Ctnr renames Container;
      package Canopy renames Ctnr.Canopy;
      The_Canopy : Canopy.Instance renames Ctnr.This_Subsystem.The_Canopy;
   begin
      return Canopy.Is_Fractured(The_Canopy);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Canopy_Fractured()");
         raise;
   end Canopy_Fractured;

   function Canopy_Latched
     return Boolean
   is
      package Ctnr renames Container;
      package Canopy renames Ctnr.Canopy;
      The_Canopy : Canopy.Instance renames Ctnr.This_Subsystem.The_Canopy;
   begin
      return Canopy.Is_Latched(The_Canopy);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Canopy_Latched()");
         raise;
   end Canopy_Latched;

   function Seat_Ejected
     return Boolean
   is
      package Ctnr renames Container;
      package Seat renames Ctnr.Ejection_Seat;
      The_Seat : Seat.Instance renames Ctnr.This_Subsystem.The_Ejection_Seat;
   begin
      return Seat.Is_Ejected(The_Seat);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Seat_Ejected()");
         raise;
   end Seat_Ejected;



   function Condensor_Blower_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Condensor_Blower.Load (Ctnr.This_Subsystem.The_Condensor_Blower);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Condensor_Blower_Load()");
         raise;
   end Condensor_Blower_Load;

   function Heat_Exchanger_Blower_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Heat_Exchanger_Blower.Load (Ctnr.This_Subsystem.The_Heat_Exchanger_Blower);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Heat_Exchanger_Blower_Load()");
         raise;
   end Heat_Exchanger_Blower_Load;

   function Ram_Air_Valve_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Ram_Air_Valve.Load (Ctnr.This_Subsystem.The_Ram_Air_Valve);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ram_Air_Valve_Load()");
         raise;
   end Ram_Air_Valve_Load;

   function OBOGS_Regulator_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Obogs_Regulator.Load (Ctnr.This_Subsystem.The_Obogs_Regulator);
   exception
      when others =>
         Log.Report("Jpats_Environmental.OBOGS_Regulator_Load()");
         raise;
   end OBOGS_Regulator_Load;

   function OBOGS_Concentrator_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Concentrator.Load (Ctnr.This_Subsystem.The_Obogs_Concentrator);
   exception
      when others =>
         Log.Report("Jpats_Environmental.OBOGS_Concentrator_Load()");
         raise;
   end OBOGS_Concentrator_Load;

   function OBOGS_Shutoff_Valve_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Obogs_Shutoff_Valve.Load (Ctnr.This_Subsystem.The_Obogs_Shutoff_Valve);
   exception
      when others =>
         Log.Report("Jpats_Environmental.OBOGS_Shutoff_Valve_Load()");
         raise;
   end OBOGS_Shutoff_Valve_Load;

   function Bi_Level_Flow_Control_Valve_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Bi_Level_Flow_Control_Valve.Load (Ctnr.This_Subsystem.The_Flow_Control_Valve);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Bi_Level_Flow_Control_Valve_Load()");
         raise;
   end Bi_Level_Flow_Control_Valve_Load;

   function Anti_Gravity_Shutoff_Valve_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Anti_Gravity_Shutoff_Valve.Load (Ctnr.This_Subsystem.The_Anti_G_Shutoff_Valve);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Anti_Gravity_Shutoff_Valve_Load()");
         raise;
   end Anti_Gravity_Shutoff_Valve_Load;

   function Canopy_Seal_Valve_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Canopy_Seal_Valve.Load (Ctnr.This_Subsystem.The_Canopy_Seal_Valve);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Canopy_Seal_Valve_Load()");
         raise;
   end Canopy_Seal_Valve_Load;

   function Evaporator_Blower_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Evaporator_Blower.Load (Ctnr.This_Subsystem.The_Evaporator_Blower);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Evaporator_Blower_Load()");
         raise;
   end Evaporator_Blower_Load;

   function Bleed_Air_Bypass_Valve_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Heat_Exchange_Bypass_Valve.Load (Ctnr.This_Subsystem.The_Heat_Exchange_Bypass_Valve);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Bleed_Air_Bypass_Valve_Load()");
         raise;
   end Bleed_Air_Bypass_Valve_Load;

   function Cockpit_Temperature_Controller_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Cockpit_Temperature_Controller.Load (Ctnr.This_Subsystem.The_Cockpit_Temperature_Controller);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Cockpit_Temperature_Controller_Load()");
         raise;
   end Cockpit_Temperature_Controller_Load;

   function Seat_Motor_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return 0.0;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Seat_Motor_Load()");
         raise;
   end Seat_Motor_Load;

   function Air_Conditioner_Compressor_Torque
     return Torque_Types.Ft_Lbf
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Ac_Compressor.Torque (Ctnr.This_Subsystem.The_Compressor);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Air_Conditioner_Compressor_Torque()");
         raise;
   end Air_Conditioner_Compressor_Torque;

   function Bleed_Air_On
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return not Ctnr.Bi_Level_Flow_Control_Valve.Is_Closed (Ctnr.This_Subsystem.The_Flow_Control_Valve);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Bleed_Air_On()");
         raise;
   end Bleed_Air_On;

   function Bleed_Flow
     return Mass_Types.Ppm
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Cockpit_Pressure_Vessel.Flow_Out_For_Eng (Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Bleed_Flow()");
         raise;
   end Bleed_Flow;

   function Ckpt_Alt
     return Float
   is
      package Ctnr renames Container;
   begin
      return Float (Ctnr.Cockpit_Pressure_Vessel.Pressure_Altitude (Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel));
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ckpt_Alt()");
         raise;
   end Ckpt_Alt;

   function Diff_Px
     return Float
   is
      package Ctnr renames Container;
   begin
      return Float (Ctnr.Cockpit_Pressure_Vessel.Differential_Pressure (Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel));
   exception
      when others =>
         Log.Report("Jpats_Environmental.Diff_Px()");
         raise;
   end Diff_Px;

   function Manual_Cold_Selected
     return Boolean
   is
      Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;
   begin
      return Io.Ecs_Temp_Cont_Man_Cold_Sw;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Manual_Cold_Selected()");
         raise;
   end Manual_Cold_Selected;

   -- sound
   package Ctnr renames Container;
   Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;

   function Canopy_Position
     return Float
   is
   begin
      return Sound.Canopy_Position;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Canopy_Position");
         raise;
   end Canopy_Position;

   function Differential_Pressure
     return Float
   is
   begin
      return Sound.Differential_Pressure;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Differential_Pressure");
         raise;
   end Differential_Pressure;

   function Pressure_System_Running
     return Float
   is
   begin
      return Sound.Pressure_System_Running;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Pressure_System_Running");
         raise;
   end Pressure_System_Running;

   function Air_Conditioning_System_Running
     return Float
   is
   begin
      return Sound.Air_Conditioning_System_Running;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Air_Conditioning_System_Running");
         raise;
   end Air_Conditioning_System_Running;

   function Windshield_Defrost_On
     return Float
   is
   begin
      return Sound.Windshield_Defrost_On;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Windshield_Defrost_On");
         raise;
   end Windshield_Defrost_On;

   function Explosive_Decompression
     return Float
   is
   begin
      return Sound.Explosive_Decompression;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Explosive_Decompression");
         raise;
   end Explosive_Decompression;


   function Freeze_Req
     return Boolean
   is
   begin
      return jpats_Environmental.Seat_Controller.Request_Freeze;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Freeze_Req");
         raise;
   end Freeze_Req;

   procedure Reset_Ejection_Seat
   is
      package Ctnr renames Container;
   begin
      Ctnr.This_Host_Interface.Ejection_Reset_Command := True;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Reset_Ejection_Seat");
         raise;
   end Reset_Ejection_Seat;

   procedure Reset_Canopy
   is
      package Ctnr renames Container;
   begin
      Ctnr.This_Host_Interface.Canopy_Fracture_Reset := True;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Reset_Canopy");
         raise;
   end Reset_Canopy;


end Jpats_Environmental;






