-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  EJECTION SEATS
--  The aircraft is equipped with Martin-Baker ejection seats.
--  Each ejection seat (Figure 1-35 and Figure 1-36) is fully
--  automatic, providing safe escape for most combinations of
--  aircraft altitude, speed, attitude, and flight path within The
--  aircraft operational envelope. The seat is capable of providing
--  safe escape from zero altitude, zero speed, up to 35,000
--  feet at speeds up to approximately 370 KIAS.
--  The seat is ejected by gas pressure developed within the
--  twin telescopic catapults when the main catapult cartridge is
--  ignited. As the seat rises on the rails, pressure is maintained
--  by two auxiliary cartridges located on the side of each catapult
--  tube. As the seat rises, the CFS initiator on the right
--  seat rail (Figure 1-36) will activate the CFS which fractures
--  the canopy. As the seat nears the top of the rails, a rocket
--  motor is fired to ensure sufficient altitude for parachute
--  deployment. Emergency oxygen is activated when ejection
--  is initiated. After ejection, the seat is stabilized and the forward
--  speed is reduced by a drogue chute, followed by the
--  automatic deployment of the personnel parachute and separation
--  of the pilot from the seat. See Section III for ejection
--  envelope and sequence.
--  Ejection is initiated by pulling the ejection control handle,
--  located on the front of each seat bucket between the pilot's
--  thighs. An interseat sequencing selector (ISS) is located in
--  the aft cockpit which permits the selection of solo (placarded
--  SOLO) or dual ejection modes (placarded BOTH). If
--  the ISS selector is set to BOTH, both seats eject (rear seat
--  first). When ISS is set to SOLO, only the initiating seat
--  ejects. The canopy fracturing system fractures the respective
--  canopy as the seat moves up the rails. Should the canopy
--  fracturing system fail, the canopy breakers mounted on the
--  seat will shatter the canopy, allowing the pilot to safely eject
--  through the canopy. After ejection, parachute deployment
--  and pilot/seat separation are automatic. A manual override
--  system is provided to restart the separation sequence in the
--  event of an automatic system failure. For high altitude ejections,
--  an altitude sensing device and a G-limiting device
--  delay seat-man separation and parachute deployment until
--  the seat and pilot are below 15,000 feet MSL and at a safe
--  parachute deployment speed.

--  SEAT HEIGHT ACTUATOR SWITCH
--  A seat height actuator switch is located on the left side console
--  in each cockpit. The switch is spring-loaded to the Off
--  position and must be moved aft to raise the seat bucket and
--  forward to lower the seat bucket. Power for the seat adjustment
--  system is provided through a circuit breaker placarded
--  SEAT ADJ, located on the generator bus circuit breaker
--  panel in each cockpit.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------

private package Jpats_Environmental.Seat_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

   function Request_Freeze
     return Boolean;

end Jpats_Environmental.Seat_Controller;
