-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with JPATS_Environmental.Container;
with Jpats_Environmental.Seat_Controller;
with Jpats_Environmental.Canopy_Controller;
with Jpats_Environmental.Pneumatics_Controller;
with Jpats_Environmental.Air_Conditioner_Controller;
with Jpats_Environmental.Cockpit_Pressure_Controller;
with Jpats_Environmental.Relay_Controller;
with Jpats_Environmental.Obogs_Controller;
with Jpats_Environmental.Anti_Gravity_Controller;
with Jpats_Environmental.Io_Interface;
with Jpats_Environmental.Ios_Interface;
with Log;
with Scheduler_Collection;


package body JPATS_Environmental.Scheduler is

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      -- call appropriate Controller methods
      Seat_Controller.Initialize;
      Canopy_Controller.Initialize;
      Pneumatics_Controller.Initialize;
      Air_Conditioner_Controller.Initialize;
      Cockpit_Pressure_Controller.Initialize;
      Relay_Controller.Initialize;
      Obogs_Controller.Initialize;
      Anti_Gravity_Controller.Initialize;


      Io_Interface.Register_Io_Variables;
      Ios_Interface.Register_Ios_Variables;

      -- Note that you can refer to another package in the same package
      -- hierarchy by its simple name, omitting the prefix.  We can say
      -- Controller.Initialize rather than JPATS_Foo.Controller.Initialize
      -- (Does not apply to the with clause, where the full name must be
      -- provided.)

--      Controller.<init method>;

   exception
      when others =>
         Log.Report("Jpats_Environmental.Scheduler.Initialize()");
         raise;
   end Initialize;

   procedure Update
     (An_Instance          : in out Instance;
      Integration_Constant : in     Float)
   is
   begin
      Seat_Controller.Update (Iconst => Integration_Constant);
      Canopy_Controller.Update (Iconst => Integration_Constant);
      Pneumatics_Controller.Update (Iconst => Integration_Constant);
      Air_Conditioner_Controller.Update (Iconst => Integration_Constant);
      Cockpit_Pressure_Controller.Update (Iconst => Integration_Constant);
      Relay_Controller.Update (Iconst => Integration_Constant);
      Obogs_Controller.Update (Iconst => Integration_Constant);
      Anti_Gravity_Controller.Update (Iconst => Integration_Constant);

      -- call appropriate Controller methods
--      Controller.<update method>;

   exception
      when others =>
         Log.Report("Jpats_Environmental.Scheduler.Update()");
         raise;
   end Update;

   procedure Update_In_Freeze
     (An_Instance : in out Instance)
   is
   begin
      -- This procedure defines behavior during total freeze
      -- for example
      --     Update (An_Instance, 0.0);
      -- will call the Scheduler's Update procedure with a 0 time step
      -- while the default
      --     null;
      -- will do nothing during total freeze
      null;
   exception
      when others =>
         Log.Report("Jpats_Environmental.Scheduler.Update_In_Freeze()");
         raise;
   end Update_In_Freeze;

   -------------------------------------------------------------------------------
   -- Routine to save a snapshot of the instance to the given stream.
   --
   -- Note that the predefined attributes 'Write and 'Output can be used on any
   -- object to save its value to the given stream. This routine should be
   -- written so that data is written to the stream in the same order that it will
   -- be read back.
   -------------------------------------------------------------------------------
   procedure Save
     (An_Instance : in out Instance;
      To_Stream   : access Ada.Streams.Root_Stream_Type'Class)
   is
   begin
     JPATS_Environmental.Container.Instance'Write
       ( To_Stream,
         JPATS_Environmental.Container.This_Subsystem);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Scheduler.Save()");
         raise;
   end Save;

   -------------------------------------------------------------------------------
   -- Routine to retrieve a snapshot of the instance from the given stream.
   --
   -- Note that the predefined attributes 'Read and 'Input can be used on any
   -- object to retrieve its value in the given stream. This routine should be
   -- written so that data is read from the stream in the same order it was placed
   -- into the stream.
   -------------------------------------------------------------------------------
   procedure Restore
     (An_Instance : in out Instance;
      From_Stream : access Ada.Streams.Root_Stream_Type'Class)
   is
   begin
     JPATS_Environmental.Container.Instance'Read
       ( From_Stream,
         Jpats_Environmental.Container.This_Subsystem);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Scheduler.Restore()");
         raise;
   end Restore;

   -------------------------------------------------------------------------------
   -- Returns the maximum amount of *bytes* that a snapshot takes up. This is
   -- used by Create_Streams to help size some interneral buffers.
   --
   -- By default, this will return the size of Instance in bytes (not counting the
   -- Save_Stream and Restore_Stream fields below). But you can override this to
   -- return a different value. You should do this if you wrote a custom Save
   -- routine which writes out data that is not contained directly in your
   -- instance (ie: in an object pointed to by your instance, or in a package body
   -- somewhere).
   -------------------------------------------------------------------------------
   function Snapshot_Size (An_Instance : Instance) return Natural is
   begin
      return JPATS_Environmental.Container.This_Subsystem'Size;
   end Snapshot_Size;


   -- Declare an instance of this scheduler to be added to the collection.

   This_Scheduler : aliased Instance;

begin

   -- Note that the string argument is no longer required.  The name of the
   -- scheduler is extracted from the tag.

   Scheduler_Collection.Register
     (This_Scheduler'Access);
exception
   when others =>
      Log.Report("Jpats_Environmental.Scheduler -- package body begin end block");
      raise;

end JPATS_Environmental.Scheduler;

