-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Environmental.Container;
with Jpats_Environmental_Types;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;
with Jpats_Powerplant;
with Log;

package body Jpats_Environmental.Relay_Controller is

   procedure Initialize
   is
      package Ctnr   renames Container;
      package Relays renames Ctnr.Relay_Collection;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Relays;
   begin
      Relays.Initialize (The_Relays);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Relay_Controller.Initialize()");
         raise;
   end Initialize;

   procedure Update
     (Iconst : in Float)
   is
      package Ctnr                    renames Container;
      package Relays                  renames Ctnr.Relay_Collection;
      package Ele                     renames Jpats_Electrical;
      package Ele_T                   renames Jpats_Electrical_Types;
      package Env_T                   renames Jpats_Environmental_Types;
      package Ac_Over_Pressure_Switch renames Ctnr.Ac_Over_Pressure_Switch;
      package Thermal_Time_Delay      renames Ctnr.Thermal_Time_Delay;
      package Oat_Switch              renames Ctnr.Oat_Switch;
      package Altitude_Switch         renames Ctnr.Altitude_Switch;
      package Ldg_Gear                renames Jpats_Landing_Gear;
      package Ldg_Gear_T              renames Jpats_Landing_Gear_Types;
      package High_Temp_Sw            renames Ctnr.Obogs_High_Temperature_Switch;
      package Bypass_Valve            renames Ctnr.Heat_Exchange_Bypass_Valve;
      package Temp_Controller         renames Ctnr.Cockpit_Temperature_Controller;
      package Pwrplnt                 renames Jpats_Powerplant;

      The_Relays              : Relays.Instance                  renames Ctnr.This_Subsystem.The_Relays;
      The_Ac_Over_Pressure_Sw : Ac_Over_Pressure_Switch.Instance renames Ctnr.This_Subsystem.The_Ac_Over_Pressure_Switch;
      The_Thermal_Time_Delay  : Thermal_Time_Delay.Instance      renames Ctnr.This_Subsystem.The_Thermal_Time_Delay;
      The_Oat_Switch          : Oat_Switch.Instance              renames Ctnr.This_Subsystem.The_Oat_Switch;
      The_Alt_Sw              : Altitude_Switch.Instance         renames Ctnr.This_Subsystem.The_Cockpit_Altitude_Switch;
      The_Obogs_High_Temp_Sw  : High_Temp_Sw.Instance            renames Ctnr.This_Subsystem.The_Obogs_High_Temperature_Switch;
      The_Bypass_Valve        : Bypass_Valve.Instance            renames Ctnr.This_Subsystem.The_Heat_Exchange_Bypass_Valve;
      The_Temp_Controller     : Temp_Controller.Instance         renames Ctnr.This_Subsystem.The_Cockpit_Temperature_Controller;

      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

      Pwr_And_Grnd : Ctnr.Relay_Array_Of_Boolean := (others => False);

   begin

      -------------------------------------
      -- Get power and ground for relays --
      -------------------------------------

      -- Defog_Select_Relay
      Pwr_And_Grnd (Env_T.Defog_Select_Relay) :=
        Io.Defog_Select_Sw_On and
        Ele.Is_Powered (Ele_T.Ckpt_Temp_Cb) and
        Ele.Is_Closed (Ele_T.Generator_On_Relay);

      --  Condensor_Blower_Relay
      Pwr_And_Grnd (Env_T.Condensor_Blower_Relay) :=
        (Oat_Switch.Is_Closed (The_Oat_Switch) and
         Thermal_Time_Delay.Is_Closed (The_Thermal_Time_Delay) and
         Ac_Over_Pressure_Switch.Is_open (The_Ac_Over_Pressure_Sw) and
         Ele.Is_Powered (Name => Ele_T.Air_Cond_Cb)) and
        (Relays.Is_Closed(The_Relays,Env_T.Defog_Select_Relay) or
         Relays.Is_Closed(The_Relays,Env_T.Cool_Command_Relay));

      --  Ejector_Valve_Relay_1
      Pwr_And_Grnd (Env_T.Ejector_Valve_Relay_1) :=
        Relays.Is_Closed(The_Relays,Env_T.Defog_Select_Relay) and
        Ele.Is_Powered (Ele_T.Ckpt_Temp_Cb);

      --  Ejector_Valve_Relay_2
      Pwr_And_Grnd (Env_T.Ejector_Valve_Relay_2) :=
        (Io.Ecs_Bleed_Air_Inflow_Off_Sw or Pwrplnt.engine_failure) and
        Ele.Is_Powered (Name => Ele_T.Inflow_Sys_Cb);

      --  Bleed_Air_Flow_Relay_1
      Pwr_And_Grnd (Env_T.Bleed_Air_Flow_Relay_1) :=
        (Io.Ecs_Bleed_Air_Inflow_Hi_Sw and not Pwrplnt.engine_failure) and
        Ele.Is_Powered (Name => Ele_T.Inflow_Sys_Cb);

      --  Bleed_Air_Flow_Relay_2
      Pwr_And_Grnd (Env_T.Bleed_Air_Flow_Relay_2) :=
        (Io.Ecs_Bleed_Air_Inflow_Hi_Sw or not (Io.Ecs_Bleed_Air_Inflow_Off_Sw or Pwrplnt.engine_failure)) and
        Ele.Is_Powered (Name => Ele_T.Inflow_Sys_Cb) and
        Altitude_Switch.Is_Closed (The_Alt_Sw) and
        Relays.Is_Open (The_Relays, Env_T.Bleed_Air_Flow_Relay_1) and
        Relays.Is_Closed (The_Relays, Env_T.Cool_Command_Relay);

      --  Ram_Air_Valve_Relay
      Pwr_And_Grnd (Env_T.Ram_Air_Valve_Relay) :=
        Ele.Is_Powered (Name => Ele_T.Ram_Air_Valve_Cb) and
        Io.Ecs_Press_Ram_Dump_Sw;

      --  Auto_Pressure_Relay
      Pwr_And_Grnd (Env_T.Auto_Pressure_Relay) :=
        Altitude_Switch.Is_Open (The_Alt_Sw) and
        (Io.Ecs_Bleed_Air_Inflow_Hi_Sw or not (Io.Ecs_Bleed_Air_Inflow_Off_Sw or Pwrplnt.engine_failure)) and
        Ele.Is_Powered (Name => Ele_T.Inflow_Sys_Cb);

      --  Cool_Command_Relay
      Pwr_And_Grnd (Env_T.Cool_Command_Relay) :=
        Ele.Is_Closed (Name => Ele_T.Generator_On_Relay) and
        Bypass_Valve.Full_Cold(The_Bypass_Valve) and
        (Temp_Controller.Decrease(The_Temp_Controller) or
         (Io.Ecs_Temp_Cont_Man_Cold_Sw and Ele.Is_Powered (Ele_T.Ckpt_Temp_Cb)));

      -- Heat_Exchanger_Blower_Relay
      Pwr_And_Grnd (Env_T.Heat_Exchanger_Blower_Relay) :=
        Ele.Is_Powered (Name => Ele_T.Inflow_Sys_Cb) and
        Ele.Is_Closed (Ele_T.Generator_On_Relay) and
        Ldg_Gear.Is_Closed (Ldg_Gear_T.Right_Landing_Gear_A2_WOW_Relay);

      -- Obogs_Duct_Temp_Sense_Relay
      Pwr_And_Grnd (Env_T.Obogs_Duct_Temp_Sense_Relay) :=
        Ele.Is_Powered (Name => Ele_T.Obogs_Cb) and
        High_Temp_Sw.Is_Closed (The_Obogs_High_Temp_Sw);

      -------------------
      -- update relays --
      -------------------

      Relays.Update
        (An_Instance      => The_Relays,
         Power_And_Ground => Pwr_And_Grnd);

   exception
      when others =>
         Log.Report("Jpats_Environmental.Relay_Controller.Update()");
         raise;
   end Update;

end Jpats_Environmental.Relay_Controller;
