-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Environmental.Container;
with Jpats_Electrical;
with Jpats_Powerplant;
with Jpats_Atmosphere;
with Force_Types;
with Jpats_Electrical_Types;
with Jpats_Simulated_Aircraft;
with Length_Types;
with Log;

package body Jpats_Environmental.Pneumatics_Controller is


   procedure Initialize
   is
      package Ctnr                     renames Container;
      package Flow_Control_Valve       renames Ctnr.Bi_Level_Flow_Control_Valve;
      package Cockpit                  renames Ctnr.Cockpit_Pressure_Vessel;
      package Bleed_Air_Solenoid_Valve renames Ctnr.Bleed_Air_Solenoid_Valve;
      package Pneu_Relief_Vlv              renames Ctnr.Pneumatic_Pressure_Relief_Valve;
      package Pneu_Reg_Vlv                renames Ctnr.Pneumatic_Regulator;
      package Defog_Solenoid_Valve     renames Ctnr.Defog_Solenoid_Valve;
      

      The_Cockpit : Cockpit.Instance renames Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel;
      The_Bleed_Air_Solenoid_Valve : Bleed_Air_Solenoid_Valve.Instance renames Ctnr.This_Subsystem.The_Bleed_Air_Solenoid_Valve;
      The_Flow_Control_Valve       : Flow_Control_Valve.Instance       renames Ctnr.This_Subsystem.The_Flow_Control_Valve;
      The_Pneu_Reg_Vlv             : Pneu_Reg_Vlv.Instance   renames Ctnr.This_Subsystem.The_Pneumatic_Regulator;
      The_Pneu_Relief_Vlv          : Pneu_Relief_Vlv.Instance renames Ctnr.This_Subsystem.The_Pneumatic_Pressure_Relief_Valve;
      The_Defog_Solenoid_Valve     : Defog_Solenoid_Valve.Instance renames Ctnr.This_Subsystem.The_Defog_Solenoid_Valve;


   begin

      Cockpit.Initialize (The_Cockpit);
      Bleed_Air_Solenoid_Valve.Initialize (The_Bleed_Air_Solenoid_Valve);
      Flow_Control_Valve.Initialize (The_Flow_Control_Valve);
      Pneu_Relief_Vlv.Initialize (The_Pneu_Relief_Vlv);
      Pneu_Reg_Vlv.Initialize (The_Pneu_Reg_Vlv);
      Defog_Solenoid_Valve.Initialize(The_Defog_Solenoid_Valve);

   exception
      when others =>
         Log.Report("Jpats_Environmental.Pneumatics_Controller.Initialize()");
         raise;
   end Initialize;

   procedure Update
     (Iconst : in Float)
   is

      package Ctnr                     renames Container;
      package Ele                      renames Jpats_Electrical;
      package Ele_T                    renames Jpats_Electrical_Types;
      package Flow_Control_Valve       renames Ctnr.Bi_Level_Flow_Control_Valve;
      package Relays                   renames Ctnr.Relay_Collection;
      package Env_T                    renames Jpats_Environmental_Types;
      package Cockpit                  renames Ctnr.Cockpit_Pressure_Vessel;
      package Pwrplnt                  renames Jpats_Powerplant;
      package Bleed_Air_Solenoid_Valve renames Ctnr.Bleed_Air_Solenoid_Valve;
      package Pneu_Relief_Vlv          renames Ctnr.Pneumatic_Pressure_Relief_Valve;
      package Pneu_Reg_Vlv             renames Ctnr.Pneumatic_Regulator;
      package Sim_Aircraft             renames Jpats_Simulated_Aircraft;
      package Defog_Solenoid_Valve     renames Ctnr.Defog_Solenoid_Valve;

      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;

      The_Relays  : Relays.Instance  renames Ctnr.This_Subsystem.The_Relays;
      The_Cockpit : Cockpit.Instance renames Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel;
      The_Bleed_Air_Solenoid_Valve : Bleed_Air_Solenoid_Valve.Instance renames Ctnr.This_Subsystem.The_Bleed_Air_Solenoid_Valve;
      The_Defog_Solenoid_Valve     : Defog_Solenoid_Valve.Instance renames Ctnr.This_Subsystem.The_Defog_Solenoid_Valve;
      The_Flow_Control_Valve       : Flow_Control_Valve.Instance       renames Ctnr.This_Subsystem.The_Flow_Control_Valve;
      The_Pneu_Reg_Vlv             : Pneu_Reg_Vlv.Instance   renames Ctnr.This_Subsystem.The_Pneumatic_Regulator;
      The_Pneu_Relief_Vlv          : Pneu_Relief_Vlv.Instance renames Ctnr.This_Subsystem.The_Pneumatic_Pressure_Relief_Valve;

      Inflow_Sys_Cb : constant Boolean := Ele.Is_Powered (Ele_T.Inflow_Sys_Cb);


      Bleed_Flow_Rly_2_Is_Open   : constant Boolean := Relays.Is_Open (The_Relays,Env_T.Bleed_Air_Flow_Relay_2);

      Flow_Control_Valve_High_In : constant Boolean := Inflow_Sys_Cb and (Io.Ecs_Bleed_Air_Inflow_Hi_Sw and not Pwrplnt.Engine_Failure)
                                                       and not IO.Ecs_Press_Ram_Dump_Sw;

      Flow_Control_Valve_Low_In  : constant Boolean := (Inflow_Sys_Cb and
                                                        (Io.Ecs_Bleed_Air_Inflow_Hi_Sw or else
                                                         not (Io.Ecs_Bleed_Air_Inflow_Off_Sw or Pwrplnt.Engine_Failure)) and
                                                        Bleed_Flow_Rly_2_Is_Open) and not IO.Ecs_Press_Ram_Dump_Sw;

      Bleed_Air_Solenoid_Valve_Power_In : constant Boolean := (Inflow_Sys_Cb and
                                                               Relays.Is_Open (The_Relays,Env_T.Ejector_Valve_Relay_2) and
                                                               Relays.Is_Closed (The_Relays,Env_T.Ejector_Valve_Relay_1));

      Defog_Solenoid_Valve_Pwr_In : constant Boolean :=  (Inflow_Sys_Cb and
                                                          ((Relays.Is_Open (The_Relays,Env_T.Ejector_Valve_Relay_1) and
                                                            Relays.Is_Open (The_Relays,Env_T.Ejector_Valve_Relay_2))
                                                           or
                                                           Relays.Is_Closed (The_Relays,Env_T.Ejector_Valve_Relay_2)));

      Bleed_Pressure_Into_Cockpit : Force_Types.Psi := 0.0;

      Bleed_Avail_From_Eng : constant Boolean := Pwrplnt.Gas_Generator_Speed_Pct > 10.0;

      Altitude : constant Length_Types.Feet := Sim_Aircraft.Get_Aircraft_Geometric_Altitude;

      Defog_On : Boolean := False;

   begin

      --------------------------
      -- INFLOW CONTROL VALVE --
      --------------------------

      Flow_Control_Valve.Update
        (An_Instance   => The_Flow_Control_Valve,
         Low_Flow_Pin  => Flow_Control_Valve_Low_In,
         High_Flow_Pin => Flow_Control_Valve_High_In);

      ------------------------------------------
      -- INFLOW CONTROL VALVE SWITCH REPEATER --
      ------------------------------------------

      if Io.Ecs_Bleed_Air_Inflow_Hi_Sw then
         Ios.Bleed_Inflow_Sw_State := 2;
      elsif Io.Ecs_Bleed_Air_Inflow_Off_Sw then
         Ios.Bleed_Inflow_Sw_State := 0;
      else
         Ios.Bleed_Inflow_Sw_State := 1;
      end if;

      ------------------------------
      -- BLEED AIR SOLENOID VALVE --
      ------------------------------

      Bleed_Air_Solenoid_Valve.Update
        ( An_Instance => The_Bleed_Air_Solenoid_Valve,
          Power_In    => Bleed_Air_Solenoid_Valve_Power_In
          );

      --------------------------
      -- DEFOG SOLENOID VALVE --
      --------------------------

      Defog_Solenoid_Valve.Update
        ( An_Instance => The_Defog_Solenoid_Valve,
          Power_In    => Defog_Solenoid_Valve_Pwr_In
          );


      -- is defog circuit complete ?
      Defog_On := (Bleed_Air_Solenoid_Valve.Is_Open(The_Bleed_Air_Solenoid_Valve)
                   and Defog_Solenoid_Valve.Is_Closed(The_Defog_Solenoid_Valve))
                   and not Io.Ecs_Press_Ram_Dump_Sw;

      -------------------------------------------------------------------
      -- BLEED AIR FLOW RATE AND PRESSURE INTO COCKPIT PRESSURE VESSEL --
      -------------------------------------------------------------------

      if Bleed_Avail_From_Eng then

         if Flow_Control_Valve.Is_High (The_Flow_Control_Valve) then


            if Altitude > 31000.0 then

               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 4.66); --psi

               if Defog_On then
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 14.4); --ppm
               else
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 7.2); --ppm
               end if;

               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm

            elsif Altitude > 25000.0 then

               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 5.02); --psi

               if Defog_On then
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 14.4); --ppm
               else
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 7.2); --ppm
               end if;

               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm

            elsif Altitude > 20000.0 then

               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 4.86); --psi

               if Defog_On then
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 14.4); --ppm
               else
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 7.2); --ppm
               end if;

               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm

            else

               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 3.93); --psi

               if Defog_On then
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 14.4); --ppm
               else
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 7.2); --ppm
               end if;

               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm

            end if;

         elsif Flow_Control_Valve.Is_Low (The_Flow_Control_Valve) then

            if Altitude > 31000.0 then

               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 3.68); --psi

               if Defog_On then
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 10.4); --ppm
               else
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 5.2); --ppm
               end if;

               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm

            elsif Altitude > 25000.0 then

               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 3.56); --psi

               if Defog_On then
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 10.4); --ppm
               else
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 5.2); --ppm
               end if;

               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm

            elsif Altitude > 20000.0 then

               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 3.66); --psi

               if Defog_On then
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 10.4); --ppm
               else
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 5.2); --ppm
               end if;

               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm

            else

               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 2.68); --psi

               if Defog_On then
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 10.4); --ppm
               else
                  Cockpit.Set_Flow_In_For_Eng
                    (An_Instance => The_Cockpit,
                     Amount      => 5.2); --ppm
               end if;

               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm

            end if;

         elsif Flow_Control_Valve.Is_Closed (The_Flow_Control_Valve) then

            if Defog_On then
               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 3.98); --psi
               Cockpit.Set_Flow_In_For_Eng
                 (An_Instance => The_Cockpit,
                  Amount      => 10.0); --ppm
               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 15.0); --ppm
            else
               Cockpit.Set_Bleed_Pressure
                 (An_Instance    => The_Cockpit,
                  Bleed_Pressure => 0.0); --psi
               Cockpit.Set_Flow_In_For_Eng
                 (An_Instance => The_Cockpit,
                  Amount      => 0.0); --ppm
               Cockpit.Set_Flow_In
                 (An_Instance => The_Cockpit,
                  Amount      => 0.0); --ppm

            end if;

         end if;

      else

         Cockpit.Set_Bleed_Pressure
           (An_Instance    => The_Cockpit,
            Bleed_Pressure => 0.0); --psi

         Cockpit.Set_Flow_In_For_Eng
           (An_Instance => The_Cockpit,
            Amount      => 0.0); --ppm

         Cockpit.Set_Flow_In
           (An_Instance => The_Cockpit,
            Amount      => 0.0); --ppm

      end if;

      ------------------------------------------------
      -- PNEUMATIC SYSTEM 18 PSI PRESSURE REGULATOR --
      ------------------------------------------------

      Pneu_Reg_Vlv.Update
        (An_Instance => The_Pneu_Reg_Vlv,
         Pressure_In => Pwrplnt.Bleed_Pressure);

      ---------------------------------------------------
      -- PNEUMATIC SYSTEM 22 PSI PRESSURE RELIEF VALVE --
      ---------------------------------------------------

      Pneu_Relief_Vlv.Update
        (An_Instance => The_Pneu_Relief_Vlv,
         Quantity_In => Ctnr.Pneumatic_Regulator.Pressure
         (Ctnr.This_Subsystem.The_Pneumatic_Regulator));

   exception
      when others =>
         Log.Report("Jpats_Environmental.Pneumatics_Controller.Update()");
         raise;
   end Update;

end Jpats_Environmental.Pneumatics_Controller;
