-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--  ON-BOARD OXYGEN GENERATING SYSTEM (OBOGS)
--  The aircraft has an on-board oxygen generating system
--  (OBOGS). The OBOGS provides each pilot with an automatically
--  regulated oxygen supply with no duration limitations.
--  Oxygen is extracted from conditioned bleed air by a
--  molecular sieve. The OBOGS distribution network includes
--  a plenum which provides a limited supply of oxygen in the
--  event of OBOGS failure. Duration of the plenum supply is
--  based upon cockpit pressurization, aircraft pressure altitude,
--  pilot regulator settings and pilot demand. If the OBOGS
--  fails, emergency oxygen is provided by manually selecting
--  the ejection seat oxygen supply. Seat oxygen is supplied
--  through the CRU-60P connector. If an OBOGS failure
--  occurs, the anti-suffocation valve will allow the pilot to
--  breathe cockpit ambient air. Figure 1-60 shows a functional
--  schematic of the OBOGS. Control of the OBOGS is provided
--  for each cockpit with a panel mounted oxygen pressure
--  regulator. OBOGS is wired directly to the main battery
--  and has no pilot resettable circuit breaker.
--  Two annunciators in each cockpit indicate OBOGS status.
--  The red OBOGS FAIL annunciator illuminates to indicate
--  either low bleed air pressure upstream of the concentrator,
--  or when the OBOGS BIT detects an internal failure. Prior to
--  engine start or with a loss of bleed air, the OBOGS FAIL
--  annunciator will illuminate due to the OBOGS low pressure
--  switch closing from lack of bleed air pressure. The annunciator
--  will extinguish once the bleed air line is pressurized.
--  When first activated, the OBOGS power up BIT is initiated
--  and the system enters a sensor warm-up period which lasts
--  approximately three minutes, during which the OBOGS
--  FAIL annunciator is inhibited. After the three minute warm-up,
--  the OBOGS FAIL annunciator will illuminate if a failure
--  is detected during the self test, or during operation, and will
--  remain illuminated until the failure is cleared.
--  If the temperature in the OBOGS ducting exceeds 200
--  degrees fahrenheit, the amber OBOGS TEMP annunciator
--  will illuminate.

--  OXYGEN PRESSURE REGULATOR
--  A panel mounted oxygen pressure regulator (Figure 1-61) (dash one) is
--  installed on the right side console of each cockpit. Each regulator
--  has a supply lever, a concentration lever, a pressure
--  lever, a built in test (BIT) button, a flow indicator (blinker)
--  and a maximum concentration flow light. Each regulator
--  panel controls OBOGS electrical power and oxygen flow
--  for the respective cockpit.
--  In the event of cockpit smoke and fumes, hypoxia symptoms,
--  or loss of cabin pressurization, the regulator can Be
--  "gang-loaded" to provide high oxygen content, pressurized
--  breathing by placing the supply lever to ON, the concentration
--  lever to MAX, and the pressure lever to EMERGENCY.

--  OXYGEN PRESSURE REGULATOR SUPPLY LEVER
--  The supply lever has two positions, placarded ON and OFF.
--  When set to OFF, OBOGS electrical power and oxygen
--  flow are cut off to the respective regulator. However, if the
--  supply lever for either regulator is ON, the OBOGS system
--  is operative. Both supply levers must be OFF to disable the
--  OBOGS system.

--  OXYGEN PRESSURE REGULATOR CONCENTRATION LEVER
--  The concentration lever has two positions, placarded NORMAL
--  and MAX. When the lever is set to the NORMAL
--  position, the regulator directs the OBOGS concentrator to
--  provide the proper oxygen concentration for the present altitude.
--  When the lever is set to MAX, the regulator directs the
--  OBOGS concentrator to supply the highest possible oxygen
--  concentration. The maximum concentration light illuminates
--  any time the concentration lever is in the MAX position.

--  OXYGEN PRESSURE REGULATOR PRESSURE LEVER
--  The pressure lever has three positions placarded, respectively,
--  EMERGENCY, NORMAL, and TEST MASK. The
--  EMERGENCY position supplies the pilot with the positive
--  pressure necessary during emergency situations such as
--  cockpit fires or hypoxia symptoms. When the lever is set to
--  NORMAL, the regulator supplies a slight positive pressure
--  in addition to the pressure demanded by the pilot through
--  the mask. The TEST MASK position supplies highly pressurized
--  flow to check the face-to-mask seal.

--  OXYGEN PRESSURE REGULATOR BIT BUTTON
--  The built in test (BIT) button is used to activate the initiated
--  OBOGS BIT (I-BIT) any time after engine start and the
--  three minute warm-up. The I-BIT provides verification that
--  the OBOGS sensor and OBOGS FAIL annunciator are operating
--  properly. Momentarily pushing the BIT button opens a
--  valve in the concentrator, which allows ambient air into the
--  concentration monitor. Once the oxygen concentration
--  drops below normal (approximately 20 to 30 seconds), the
--  OBOGS FAIL light should illuminate. Once the valve
--  closes and oxygen concentration in the monitor returns to
--  normal, the OBOGS FAIL annunciator should extinguish
--  within two minutes. If the annunciator fails to illuminate or
--  extinguish as expected, either the annunciator or the monitor
--  has failed.

--  OXYGEN PRESSURE REGULATOR FLOW INDICATOR
--  The regulator flow indicator provides a visual indication of
--  oxygen flow through the regulator. Each breath taken
--  through the regulator activates the flow indicator, which
--  illuminates for the duration of the flow.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------

private package Jpats_Environmental.Obogs_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Environmental.Obogs_Controller;
