-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Environmental.Container;

with Jpats_Ios_Interface;
with Log;

package body Jpats_Environmental.Ios_Interface is

   package Ctnr renames Jpats_Environmental.Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   package JII renames Jpats_Ios_Interface;


         -- resets
   procedure Eject_Reset_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Eject_Reset := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Eject_Reset_Command()");
         raise;
   end Eject_Reset_Command;

   procedure Canopy_Fracture_Reset_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Canopy_Fracture_Reset := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Canopy_Fracture_Reset_Command()");
         raise;
   end Canopy_Fracture_Reset_Command;

         -- malfs
   procedure Auto_Mode_Over_Temp_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Auto_Mode_Over_Temp_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Auto_Mode_Over_Temp_Malf_Command()");
         raise;
   end Auto_Mode_Over_Temp_Malf_Command;

   procedure Rapid_Decompression_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Rapid_Decompression_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Rapid_Decompression_Malf_Command()");
         raise;
   end Rapid_Decompression_Malf_Command;

   procedure Slow_Decompression_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Slow_Decompression_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Slow_Decompression_Malf_Command()");
         raise;
   end Slow_Decompression_Malf_Command;

   procedure Over_Pressure_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Over_Pressure_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Over_Pressure_Malf_Command()");
         raise;
   end Over_Pressure_Malf_Command;

   procedure Canopy_Annun_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Canopy_Annun_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Canopy_Annun_Malf_Command()");
         raise;
   end Canopy_Annun_Malf_Command;


   procedure Obogs_Fail_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Obogs_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Obogs_Fail_Malf_Command()");
         raise;
   end Obogs_Fail_Malf_Command;

   procedure Obogs_Heat_Exch_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Obogs_Heat_Exch_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Obogs_Heat_Exch_Malf_Command()");
         raise;
   end Obogs_Heat_Exch_Malf_Command;


   procedure Register_Ios_Variables
   is
   begin

      JPATS_IOS_Interface.Register
        (Name        => "Ejection_Velocity",
         Variable    => Ios.Ejection_Velocity'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ejection_Bank_Angle",
         Variable    => Ios.Ejection_Bank_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ejection_Sink_Rate",
         Variable    => Ios.Ejection_Sink_Rate'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ejection_Dive_Angle",
         Variable    => Ios.Ejection_Dive_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ejection_Envelope_Height",
         Variable    => Ios.Ejection_Envelope_Height'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ejection_Altitude",
         Variable    => Ios.Ejection_Altitude'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cockpit_Pressure_Altitude",
         Variable    => Ios.Cockpit_Pressure_Altitude'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cockpit_Differential_Pressure",
         Variable    => Ios.Cockpit_Differential_Pressure'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ecs_Air_Cond_On_Sw",
         Variable    => Io.Ecs_Air_Cond_On_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Bleed_Inflow_Sw_State",
         Variable    => Ios.Bleed_Inflow_Sw_State'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Pressure_Sw_State",
         Variable    => Ios.Pressure_Sw_State'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ram_Air_Flow_Sw_State",
         Variable    => Ios.Ram_Air_Flow_Sw_State'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Obogs_Sw_State",
         Variable    => Ios.Obogs_Sw_State'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Oxygen_Sw_State",
         Variable    => Ios.Oxygen_Sw_State'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Supply_Sw_State",
         Variable    => Ios.Supply_Sw_State'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Eject_Reset",
         Variable    => Ios.Eject_Reset'Address,
         Set_Routine => Eject_Reset_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Canopy_Fracture_Reset",
         Variable    => Ios.Canopy_Fracture_Reset'Address,
         Set_Routine => Canopy_Fracture_Reset_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Auto_Mode_Over_Temp_Malf",
         Variable    => Ios.Auto_Mode_Over_Temp_Malf'Address,
         Set_Routine => Auto_Mode_Over_Temp_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Rapid_Decompression_Malf",
         Variable    => Ios.Rapid_Decompression_Malf'Address,
         Set_Routine => Rapid_Decompression_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Slow_Decompression_Malf",
         Variable    => Ios.Slow_Decompression_Malf'Address,
         Set_Routine => Slow_Decompression_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Over_Pressure_Malf",
         Variable    => Ios.Over_Pressure_Malf'Address,
         Set_Routine => Over_Pressure_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Canopy_Annun_Malf",
         Variable    => Ios.Canopy_Annun_Malf'Address,
         Set_Routine => Canopy_Annun_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Eject_Handle",
         Variable    => Io.Eject_Handle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Canopy_Fracture",
         Variable    => Io.Canopy_Fracture'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Inertia_Real_Mode_Select",
         Variable    => Io.Inertia_Real_Mode_Select'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Emer_Oxygen_Sw",
         Variable    => Io.Oxygen_Handle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Oxygen_Connect",
         Variable    => Io.Oxygen_Connect'Address
         );


      JPATS_IOS_Interface.Register
        (Name        => "Bit_Sw",
         Variable    => Io.Bit_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ecs_Temp_Cont_Man_Cold_Sw",
         Variable    => Io.Ecs_Temp_Cont_Man_Cold_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Auto_Temp_Control_Sw",
         Variable    => Ios.Auto_Temp_Control_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ejection_Status",
         Variable    => Ios.Ejection_Status'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Is_Ejected",
         Variable    => Ios.Is_Ejected'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Defog_On_Sw",
         Variable    => Io.Defog_Select_Sw_On'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ecs_Evap_Blo_Fan_On_Sw",
         Variable    => Io.Ecs_Evap_Blo_Fan_On_Sw'Address
         );

      -- JPATS_IOS_Interface.Register
      --   (Name        => "Ecs_Evap_Blo_Fan_Cont",
      --    Variable    => Io.Ecs_Evap_Blo_Fan_Cont'Address
      --    );


      -----------------------------------------------------
      ----------  DEBUG ----------------------------------
      ----------------------------------------------------
      JPATS_IOS_Interface.Register
        (Name        => "Control_Valve_Position",
         Variable    => Ios.Control_Valve_Position'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Control_Valve_Area",
         Variable    => Ios.Control_Valve_Area'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Safety_Valve_Position",
         Variable    => Ios.Safety_Valve_Position'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Safety_Valve_Area",
         Variable    => Ios.Safety_Valve_Area'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Total_Leak_Area",
         Variable    => Ios.Total_Leak_Area'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Flow_Into_Cockpit",
         Variable    => Ios.Flow_Into_Cockpit'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Flow_Out_of_Cockpit",
         Variable    => Ios.Flow_Out_of_Cockpit'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Total_Flow_Ppm",
         Variable    => Ios.Total_Flow_Ppm'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cockpit_Air_Mass",
         Variable    => Ios.Cockpit_Air_Mass'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ambient_Pressure_Psi",
         Variable    => Ios.Ambient_Pressure_Psi'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ambient_Pressure_Alt",
         Variable    => Ios.Ambient_Pressure_Alt'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cockpit_Temp_F",
         Variable    => Ios.Cockpit_Temp_F'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cockpit_Roc",
         Variable    => Ios.Cockpit_Roc'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Sac_Roc",
         Variable    => Ios.Sac_Roc'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Selected_Altitude",
         Variable    => Ios.Selected_Altitude'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Aircraft_Pressure_Altitude",
         Variable    => Ios.Aircraft_Pressure_Altitude'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Obogs_Fail_Malf",
         Variable    => Ios.Obogs_Fail_Malf'Address,
         Set_Routine => Obogs_Fail_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Obogs_Heat_Exch_Malf",
         Variable    => Ios.Obogs_Heat_Exch_Malf'Address,
         Set_Routine => Obogs_Heat_Exch_Malf_Command'Access
         );

      -----------------------------------------------------
      ----------------------------------------------------
      -----------------------------------------------------
      JPATS_IOS_Interface.Register
        (Name        => "Canopy_Shut_Handle_Sw",
         Variable    => Io.Canopy_Handle_Lock_Sw'Address
         );

   exception
      when others =>
         Log.Report("Jpats_Environmental.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;


end Jpats_Environmental.Ios_Interface;

