-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Environmental.Container;
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;
with Log;

package body Jpats_Environmental.Io_Interface is

   package JIOT renames Jpats_Io_Types;
   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   procedure Register_Io_Variables
   is
   begin

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_TEMP_CONT_MAN_HOT_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Temp_Cont_Man_Hot_Sw'Address,
         A_Size          => Io.Ecs_Temp_Cont_Man_Hot_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_TEMP_CONT_MAN_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Temp_Cont_Man_Sw'Address,
         A_Size          => Io.Ecs_Temp_Cont_Man_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_TEMP_CONT_MAN_COLD_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Temp_Cont_Man_Cold_Sw'Address,
         A_Size          => Io.Ecs_Temp_Cont_Man_Cold_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_TEMP_CONT_AUTO_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Temp_Cont_Auto_Sw'Address,
         A_Size          => Io.Ecs_Temp_Cont_Auto_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_AIR_COND_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Air_Cond_On_Sw'Address,
         A_Size          => Io.Ecs_Air_Cond_On_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_BLEED_AIR_INFLOW_HI_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Bleed_Air_Inflow_Hi_Sw'Address,
         A_Size          => Io.Ecs_Bleed_Air_Inflow_Hi_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_BLEED_AIR_INFLOW_OFF_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Bleed_Air_Inflow_Off_Sw'Address,
         A_Size          => Io.Ecs_Bleed_Air_Inflow_Off_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_PRESS_RAM_DUMP_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Press_Ram_Dump_Sw'Address,
         A_Size          => Io.Ecs_Press_Ram_Dump_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_PRESS_NORM_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Press_Norm_Sw'Address,
         A_Size          => Io.Ecs_Press_Norm_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_RAM_AIR_FLOW_HI_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Ram_Air_Flow_Hi_Sw'Address,
         A_Size          => Io.Ecs_Ram_Air_Flow_Hi_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_RAM_AIR_FLOW_OFF_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Ram_Air_Flow_Off_Sw'Address,
         A_Size          => Io.Ecs_Ram_Air_Flow_Off_Sw'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "EMER_OXYGEN_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Emer_Oxygen_Sw'Address,
         A_Size          => Io.Emer_Oxygen_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TEST_OXYGEN_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Test_Oxygen_Sw'Address,
         A_Size          => Io.Test_Oxygen_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "OXYGEN_MAX_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Oxygen_Max_Sw'Address,
         A_Size          => Io.Oxygen_Max_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "BIT_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Bit_Sw'Address,
         A_Size          => Io.Bit_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "OXYGEN_SUPPLY_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Oxygen_Supply_On_Sw'Address,
         A_Size          => Io.Oxygen_Supply_On_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CANOPY_FRACTURE",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Canopy_Fracture'Address,
         A_Size          => Io.Canopy_Fracture'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CANOPY_LOCK_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.CANOPY_HANDLE_LOCK_SW'Address,
         A_Size          => Io.CANOPY_HANDLE_LOCK_SW'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "EJECT_HANDLE",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Eject_Handle'Address,
         A_Size          => Io.Eject_Handle'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "INERTIA_REAL_MODE_SELECT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Inertia_Real_Mode_Select'Address,
         A_Size          => Io.Inertia_Real_Mode_Select'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "OXYGEN_HANDLE",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Oxygen_Handle'Address,
         A_Size          => Io.Oxygen_Handle'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "OXYGEN_CONNECT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Oxygen_Connect'Address,
         A_Size          => Io.Oxygen_Connect'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "OXYGEN_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Oxygen_Lt'Address,
         A_Size          => Io.Oxygen_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ECS_TEMP_CONT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Temp_Cont'Address,
         A_Size          => Io.Ecs_Temp_Cont'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "OXYGEN_FLOW_METER",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Oxygen_Flow_Meter'Address,
         A_Size          => Io.Oxygen_Flow_Meter'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANTI_SUFFICATION_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Anti_Suffocation_Sw'Address,
         A_Size          => Io.Anti_Suffocation_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "DEFOG_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Defog_Select_Sw_On'Address,
         A_Size          => Io.Defog_Select_Sw_On'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ecs_evap_blo_fan_on_sw",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ecs_Evap_Blo_Fan_On_Sw'Address,
         A_Size          => Io.Ecs_Evap_Blo_Fan_On_Sw'Size);

      -- Jpats_Io.Map_To_Icd_mnemonic
      --   (An_Interface    => JIOT.Flight_Deck,
      --    An_Icd_Mnemonic => "ECS_EVAP_BLO_FAN_CONT",
      --    A_Direction     => IO_Types.Input,
      --    An_Address      => Io.Ecs_Evap_Blo_Fan_Cont'Address,
      --    A_Size          => Io.Ecs_Evap_Blo_Fan_Cont'Size);


   exception
      when others =>
         Log.Report("Jpats_Environmental.Io_Interface.Register_Io_Variables()");
         raise;
   end Register_Io_Variables;

end Jpats_Environmental.Io_Interface;

