-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Temperature_Types;
with Cockpit_Temperature_Controller_G;
with Anti_Gravity_Shutoff_Valve_G;
with Anti_Gravity_Valve_G;
with Ejection_Seat_G;
with Canopy_G;
with Mechanical_Two_Position_Valve_G;
with Bleed_Air_Flow_Control_Valve_G;
with Ram_Air_Valve_G;
with Solenoid_Valve_G;
with Solenoid_Dump_Valve_G;
with Bypass_Valve_G;
with Outflow_Valve_G;
with Quantity_Low_Switch_G;
with Quantity_High_Switch_G;
with Coil_Relay_G;
with Coil_Relay_Collection_G;
with Cockpit_Pressure_Vessel_G;
with Quantity_Relief_Valve_G;
with Pneumatic_Regulator_G;
with Altitude_Switch_G;
with Ac_Compressor_G;
with Fan_G;
with Blower_G;
with Oat_Switch_G;
with Obogs_Regulator_G;
with Obogs_Concentrator_G;
with Quantity_High_Switch_G;
with Quantity_Low_Switch_G;
with Valve_Position_Switch_G;
with Evaporator_Blower_G;
with Electrical_Units_Types;
with Jpats_Environmental_Types;
with Force_Types;
with Thermal_Time_Delay_G;
with Length_Types;
with Angle_Types;
with Canopy_Seal_Valve_G;
with Safety_Valve_G;
private package Jpats_Environmental.Container is

   ----------
   -- SEAT --
   ----------
   package Ejection_Seat is new Ejection_Seat_G
     (Package_Name => "Jpats_Environmental.Container.Ejection_Seat");

   ------------
   -- CANOPY --
   ------------
   package Canopy is new Canopy_G
     (Package_Name => "Jpats_Environmental.Container.Canopy");

   -------------------------
   -- ANTI GRAVITY SYSTEM --
   -------------------------
   package Anti_Gravity_Shutoff_Valve is new Anti_Gravity_Shutoff_Valve_G
     (Current_Type    => Electrical_Units_Types.Amps,
      Powered_Load    => 3.5,
      Pressure_Type   => Force_Types.Psi,
      Flow_Rate_Type  => Float,
      K_Open          => 1.0,
      K_Closed        => 0.0,
      Package_Name    => "Jpats_Environmental.Container.Anti_Gravity_Shutoff_Valve");
   package Anti_Gravity_Valve is new Anti_Gravity_Valve_G
     (Pressure_Type  => Force_Types.Psi,
      Flow_Rate_Type => Float,
      Package_Name   => "Jpats_Environmental.Container.Anti_Gravity_Valve");

   ---------------------------------
   -- HEAT EXCHANGER BYPASS VALVE --
   ---------------------------------
   subtype Bypass_Valve_Position_Type is Float range 0.0..90.0;
   package Heat_Exchange_Bypass_Valve is new Bypass_Valve_G
     (Position_Type => Bypass_Valve_Position_Type,
      Current_Type  => Electrical_Units_Types.Amps,
      Package_Name  => "Jpats_Environmental.Container.Heat_Exchange_Bypass_Valve");


   package Bleed_Air_Solenoid_Valve is new Solenoid_Valve_G
     (Ampere_Type               => Electrical_Units_Types.Amps,
      Valve_Load                => 3.3,
      Open_Restriction_Factor   => 1.0,
      Closed_Restriction_Factor => 0.0,
      Package_Name              => "Jpats_Environmental.Container.Bleed_Air_Solenoid_Valve");

   package Defog_Solenoid_Valve is new Solenoid_Valve_G
     (Ampere_Type               => Electrical_Units_Types.Amps,
      Valve_Load                => 3.3,
      Open_Restriction_Factor   => 1.0,
      Closed_Restriction_Factor => 0.0,
      Package_Name              => "Jpats_Environmental.Container.Defog_Solenoid_Valve");


   -- shutoff valve
   package Bleed_Air_Shutoff_Valve is new Mechanical_Two_Position_Valve_G
     (Package_Name  => "Jpats_Environmental.Container.Bleed_Air_Shutoff_Valve");

   -- bi level flow control valve
   package Bi_Level_Flow_Control_Valve is new Bleed_Air_Flow_Control_Valve_G
     (Current_Type                 => Electrical_Units_Types.Amps,
      High_Flow_Load               => 5.0,
      High_Flow_Restriction_Factor => 1.0,
      Low_Flow_Load                => 2.5,
      Low_Flow_Restriction_Factor  => 0.5,
      Package_Name                 => "Jpats_Environmental.Container.Bi_Level_Flow_Control_Valve");
   -- ram air valve
   package Ram_Air_Valve is new Ram_Air_Valve_G
     (Current_Type     => Electrical_Units_Types.Amps,
      High_Flow_Load   => 4.0,
      Normal_Flow_Load => 2.1,
      Package_Name     => "Jpats_Environmental.Container.Ram_Air_Valve");

   -- outflow (control) valve
   subtype Control_Valve_Position_Type is Float range 0.0..10.0;
   subtype Area_Type is Float;
   subtype Roc_Error_Type is Float;
   package Control_Valve is new Outflow_Valve_G
     (Position_Type  => Control_Valve_Position_Type,
      Area_Type      => Length_Types.Sq_Inches,
      Roc_Error_Type => Roc_Error_Type,
      Package_Name   => "Jpats_Environmental.Container.Control_Valve");
   -- safety valve
   package Safety_Valve is new Safety_Valve_G
     (Position_Type => Control_Valve_Position_Type,
      Area_Type     => Length_Types.Sq_Inches,
      Package_Name  => "Jpats_Environmental.Container.Safety_Valve");

   -- soleniod dump valve
   package Solenoid_Dump_Valve is new Solenoid_Dump_Valve_G
     (Current_Type => Electrical_Units_Types.Amps,
      Valve_Load   => 0.50,
      Package_Name => "Jpats_Environmental.Container.Solenoid_Dump_Valve");

   -- air condition low pressure switch
--   subtype Ac_Pressure_Type is Float;
   package Ac_Low_Pressure_Switch is new Quantity_Low_Switch_G
     (Quantity_Type       => Force_Types.Psi,
      Low_Level_Threshold => 2.5,
      Reset_Threshold     => 100.0,
      Package_Name        => "Jpats_Environmental.Container.Ac_Low_Pressure_Switch");
   -- air condition over pressure switch
   package Ac_Over_Pressure_Switch is new Quantity_Low_Switch_G
     (Quantity_Type       => Force_Types.Psi,
      Low_Level_Threshold => 380.0,
      Reset_Threshold     => 230.0,
      Package_Name        => "Jpats_Environmental.Container.Ac_Over_Pressure_Switch");

   package Ac_Over_Temp_Sw is new Quantity_High_Switch_G
     (Quantity_Type        => Temperature_Types.Fahrenheit,
      High_Level_Threshold => 300.0,
      Reset_Threshold      => 300.0,
      Package_Name         => "Jpats_Environmental.Container.Ac_Over_Temp_Sw");


   -- thermal time delay
   package Thermal_Time_Delay is new Thermal_Time_Delay_G
     (Sensed_Type  => Float,
      Package_Name => "Jpats_Environmental.Container.Thermal_Time_Delay");

   -- obogs system
   -- obogs low pressure switch
   package Obogs_Low_Pressure_Switch is new Quantity_Low_Switch_G
     (Quantity_Type       => Force_Types.Psi,
      Low_Level_Threshold => 6.5,
      Reset_Threshold     => 14.0,
      Package_Name        => "Jpats_Environmental.Container.Obogs_Low_Pressure_Switch");
   -- obogs high temp switch
   package Obogs_High_Temperature_Switch is new Quantity_High_Switch_G
     (Quantity_Type        => Temperature_Types.Fahrenheit,
      High_Level_Threshold => 200.0,
      Reset_Threshold      => 185.0,
      Package_Name         => "Jpats_Environmental.Container.Obogs_High_Temperature_Switch");

   -- obogs system shutoff valve
   package Obogs_Shutoff_Valve is new Solenoid_Valve_G
     (Ampere_Type               => Electrical_Units_Types.Amps,
      Valve_Load                => 3.3,
      Open_Restriction_Factor   => 1.0,
      Closed_Restriction_Factor => 0.0,
      Package_Name              => "Jpats_Environmental.Container.Obogs_Shutoff_Valve");

   -- obogs concentrator
   subtype Oxygen_Concentration_Type is Float range 0.0..100.0;

   package Concentrator is new Obogs_Concentrator_G
     (Oxygen_Concentration_Type => Oxygen_Concentration_Type,
      Pressure_Type             => Force_Types.Psi,
      Altitude_Type             => Length_Types.Feet,
      Current_Type              => Electrical_Units_Types.Amps,
      Package_Name              => "Jpats_Environmental.Container.Concentrator");
   -- obogs regulator
   package Obogs_Regulator is new Obogs_Regulator_G
     (Pressure_Type => Force_Types.Psi,
      Current_Type  => Electrical_Units_Types.Amps,
      Package_Name  => "Jpats_Environmental.Container.Obogs_Regulator");


   -- oat temp switch for ac system

   package Oat_Switch is new Oat_Switch_G
     (Temperature_Type => Temperature_Types.Fahrenheit,
      Temp_Threshold   => 40.0,
      Package_Name     => "Jpats_Environmental.Container.Oat_Switch");
   -- condensor blower
   package Condensor_Blower is new Blower_G
     (Current_Type      => Electrical_Units_Types.Amps,
      Flow_Rate_Type    => Float,
      Engaged_Load      => 10.5,
      Flow_Rate_When_On => 100.0,
      Package_Name      => "Jpats_Environmental.Container.Condensor_Blower");
   -- evaporator blower
   package Evaporator_Blower is new Evaporator_Blower_G
     (Current_Type   => Electrical_Units_Types.Amps,
      Flow_Rate_Type => Float,
      High_Load      => 10.0,
      Low_Load       => 5.0,
      High_Flow_Rate => 20.0,
      Low_Flow_Rate  => 10.0,
      Package_Name   => "Jpats_Environmental.Container.Evaporator_Blower");
   -- heat exchanger blower
   package Heat_Exchanger_Blower is new Blower_G
     (Current_Type      => Electrical_Units_Types.Amps,
      Flow_Rate_Type    => Float,
      Engaged_Load      => 11.5,
      Flow_Rate_When_On => 10.0,
      Package_Name      => "Jpats_Environmental.Container.Heat_Exchanger_Blower");
   -- vent fan
   package Vent_Fan is new Fan_G
     (Ampere_Type  => Electrical_Units_Types.Amps,
      Engaged_Load => 17.5,
      Package_Name => "Jpats_Environmental.Container.Vent_Fan");
   -- air conditioner compressor
   package Ac_Compressor is new Ac_Compressor_G
     (Ampere_Type              => Electrical_Units_Types.Amps,
      Torque_Type              => Torque_Types.Ft_Lbf,
      Rpm_Type                 => Angle_Types.Rpm,
      Shaft_Horsepower_Type    => Float,
      Engaged_Load             => 20.5,
      Engaged_Shaft_Horsepower => 12.0,
      Package_Name             => "Jpats_Environmental.Container.Ac_Compressor");
   -- altitude switch
   package Altitude_Switch is new Altitude_Switch_G
     (Altitude_Type      => Length_Types.Feet,
      Altitude_Threshold => 7500.0,
      Package_Name       => "Jpats_Environmental.Container.Altitude_Switch");
   -- bypass valve 30 degrees from full cold switch
   subtype Bypass_Valve_Position is Float range 0.0..90.0;
   package Bypass_Valve_30_Degrees_From_Full_Cold_Switch is new Valve_Position_Switch_G
     (Valve_Position_Type      => Bypass_Valve_Position,
      Valve_Position_Threshold => 0.3,
      Package_Name             => "Jpats_Environmental.Container.Bypass_Valve_30_Degrees_From_Full_Cold_Switch");
   -- pneumatic regulator
   package Pneumatic_Regulator is new Pneumatic_Regulator_G
     (Pressure_Type      => Force_Types.Psi,
      Regulated_Pressure => 18.0,
      Package_Name       => "Jpats_Environmental.Container.Pneumatic_Regulator");
   -- pneumatic pressure relief valve
   package Pneumatic_Pressure_Relief_Valve is new Quantity_Relief_Valve_G
     (Quantity_Type => Force_Types.Psi,
      Threshold     => 22.0,
      Package_Name  => "Jpats_Environmental.Container.Pneumatic_Pressure_Relief_Valve");

   package Cockpit_Pressure_Vessel is new Cockpit_Pressure_Vessel_G
     (Altitude_Type              => Length_Types.Feet,
      Temperature_Type           => Temperature_Types.Fahrenheit,
      Flow_Rate_Type             => Mass_Types.Ppm,
      Pressure_Type              => Force_Types.Psi,
      Mass_Type                  => Mass_Types.Lbm,
      Volume_Type                => Length_Types.Cubic_Inches,
      Volume                     => 160704.0,
      Velocity_Type              => Length_Types.Feet_Per_Min,
      Package_Name               => "Jpats_Environmental.Container.Cockpit_Pressure_Vessel");

   package Canopy_Seal_Valve is new Canopy_Seal_Valve_G
     (Current_Type              => Electrical_Units_Types.Amps,
      Valve_Load                => 2.0,
      Open_Restriction_Factor   => 1.0,
      Closed_Restriction_Factor => 0.0,
      Package_Name              => "Jpats_Environmental.Container.Canopy_Seal_Valve");



   package Coil_Relay is new Coil_Relay_G
     (Ampere_Type => Electrical_Units_Types.amps,
      Closed_Load => 0.05,
      Package_Name => "Jpats_Environmental.Container.Coil_Relay");
   type Array_Of_Coil_Relay_Type is array (Jpats_Environmental_Types.Relay_Name_Type) of Coil_Relay.Instance;
   type Relay_Array_Of_Boolean is array (Jpats_Environmental_Types.Relay_Name_Type) of Boolean;
   package Relay_Collection is new Coil_Relay_Collection_G
     (Ampere_Type           => Electrical_Units_Types.Amps,
      Relay_Name_Type       => Jpats_Environmental_Types.Relay_Name_Type,
      Relay_Type            => Coil_Relay.Instance,
      Array_Of_Relay_Type   => Array_Of_Coil_Relay_Type,
      Array_Of_Boolean_Type => Relay_Array_Of_Boolean,
      Open_A_Relay          => Coil_Relay.Open,
      Close_A_Relay         => Coil_Relay.Close,
      Initialize_A_Relay    => Coil_Relay.Initialize,
      A_Relay_Load          => Coil_Relay.Load,
      A_Relay_Is_Open       => Coil_Relay.Is_Open,
      A_Relay_Is_Closed     => Coil_Relay.Is_Closed,
      Update_A_Relay        => Coil_Relay.Update,
      Package_Name          => "Jpats_Environmental.Container.Relay_Collection");


   package Cockpit_Temperature_Controller is new Cockpit_Temperature_Controller_G
     (Temperature_Type => Temperature_Types.Fahrenheit,
      Current_Type     => Electrical_Units_Types.Amps,
      Package_Name     => "Jpats_Environmental.Container.Cockpit_Temperature_Controller");



   type Instance is
      record
         The_Solenoid_Dump_Valve                           : Solenoid_Dump_Valve.Instance;
         The_Canopy_Seal_Valve                             : Canopy_Seal_Valve.Instance;
         The_Cockpit_Temperature_Controller                : Cockpit_Temperature_Controller.Instance;
         The_Defog_Solenoid_Valve                          : Defog_Solenoid_Valve.Instance;
         The_Bleed_Air_Solenoid_Valve                      : Bleed_Air_Solenoid_Valve.Instance;
         The_Thermal_Time_Delay                            : Thermal_Time_Delay.Instance;
         The_Ejection_Seat                                 : Ejection_Seat.Instance;
         The_Canopy                                        : Canopy.Instance;
         The_Firewall_Bleed_Air_Shutoff_Valve              : Bleed_Air_Shutoff_Valve.Instance;
         The_Flow_Control_Valve                            : Bi_Level_Flow_Control_Valve.Instance;
         The_Ram_Air_Valve                                 : Ram_Air_Valve.Instance;
         The_Anti_G_Shutoff_Valve                          : Anti_Gravity_Shutoff_Valve.Instance;
         The_Anti_Gravity_Valve                            : Anti_Gravity_Valve.Instance;
--The_Pneumatic_System_Shutoff_Valve                : Pneumatic_System_Shutoff_Valve.Instance; = ANTI G SHUTOFF VALVE NOW
         The_Heat_Exchange_Bypass_Valve                    : Heat_Exchange_Bypass_Valve.Instance;
         The_Control_Valve                                 : Control_Valve.Instance;
         The_Safety_Valve                                  : Safety_Valve.Instance;
         The_Oat_Switch                                    : Oat_Switch.Instance;
         The_Ac_Low_Pressure_Switch                        : Ac_Low_Pressure_Switch.Instance;
         The_Ac_Over_Pressure_Switch                       : Ac_Over_Pressure_Switch.Instance;
         The_Ac_Over_Temp_Switch                           : Ac_Over_Temp_Sw.Instance;
         The_Condensor_Blower                              : Condensor_Blower.Instance;
         The_Evaporator_Blower                             : Evaporator_Blower.Instance;
         The_Heat_Exchanger_Blower                         : Heat_Exchanger_Blower.Instance;
         The_Vent_Fan                                      : Vent_Fan.Instance;
         The_Compressor                                    : Ac_Compressor.Instance;
         The_Cockpit_Altitude_Switch                       : Altitude_Switch.Instance;
         The_Bypass_Valve_30_Degrees_From_Full_Cold_Switch : Bypass_Valve_30_Degrees_From_Full_Cold_Switch.Instance;
         The_Pneumatic_Regulator                           : Pneumatic_Regulator.Instance;
         The_Pneumatic_Pressure_Relief_Valve               : Pneumatic_Pressure_Relief_Valve.Instance;
         The_Cockpit_Pressure_Vessel                       : Cockpit_Pressure_Vessel.Instance;
         The_Obogs_Low_Pressure_Switch                     : Obogs_Low_Pressure_Switch.Instance;
         The_Obogs_High_Temperature_Switch                 : Obogs_High_Temperature_Switch.Instance;
         The_Obogs_Shutoff_Valve                           : Obogs_Shutoff_Valve.Instance;
         The_Obogs_Concentrator                            : Concentrator.Instance;
         The_Obogs_Regulator                               : Obogs_Regulator.Instance;
         The_Relays                                        : Relay_Collection.Instance;


         ACC_Target_Temp : Temperature_Types.Fahrenheit := 70.0;
         ACC_Duct_Temp_Timer : Float := 0.0;
         ACC_Duct_Temp_Target :Temperature_Types.Fahrenheit := 70.0;
         CC_Canopy_Fracture_Last_Pass : Boolean := False;
         CC_Canopy_Is_Fractured : Boolean := False;
         CC_Canopy_Is_Fractured_Last_Pass : Boolean := False;
         CPC_Mass_Init_Counter     : float := 0.0;
         CPC_Cockpit_Roc_Last_Pass : Length_Types.Feet := 0.0;
         CPC_Malfunction_Leak_Area : Length_Types.Sq_Inches := 0.0;
         CPC_Differential_Pressure_Last_Pass : Force_Types.Psi := 0.0;
         SC_Eject_Handle_Last_Pass : Boolean := False;
         SC_Ejection_Status        : Boolean := True;
         SC_Pilot_Is_Ejected       : Boolean := False;
         SC_Pilot_Is_Ejected_Last_Pass : Boolean := False;
         SC_Freeze_Request : Boolean := False;

      end record;
   This_Subsystem : Instance;


   type Io_Interface_Instance is
      record
         -- digital input
         Ecs_Temp_Cont_Man_Hot_Sw                          : Boolean := False;
         Ecs_Temp_Cont_Man_Sw                              : Boolean := True;
         Ecs_Temp_Cont_Man_Cold_Sw                         : Boolean := False;
         Ecs_Temp_Cont_Auto_Sw                             : Boolean := False;
         Ecs_Air_Cond_On_Sw                                : Boolean := False;
         Ecs_Bleed_Air_Inflow_Hi_Sw                        : Boolean := False;
         Ecs_Bleed_Air_Inflow_Off_Sw                       : Boolean := True;
         Ecs_Press_Ram_Dump_Sw                             : Boolean := False;
         Ecs_Press_Norm_Sw                                 : Boolean := True;
         Ecs_Ram_Air_Flow_Hi_Sw                            : Boolean := False;
         Ecs_Ram_Air_Flow_Off_Sw                           : Boolean := True;
         Emer_Oxygen_Sw                                    : Boolean := False;
         Test_Oxygen_Sw                                    : Boolean := False;
         Oxygen_Max_Sw                                     : Boolean := False;
         Bit_Sw                                            : Boolean := False;
         Oxygen_Supply_On_Sw                               : Boolean := False;
         Canopy_Fracture                                   : Boolean := False;
         Canopy_Handle_Lock_Sw                             : Boolean := False;
         Eject_Handle                                      : Boolean := False;
         Inertia_Real_Mode_Select                          : Boolean := False;
         Oxygen_Handle                                     : Boolean := False;
         Oxygen_Connect                                    : Boolean := False;
         Anti_Suffocation_Sw                               : Boolean := False;
         Defog_Select_Sw_On                                : Boolean := False;

         Ecs_Evap_Blo_Fan_On_Sw                            : Boolean := False;
         Ecs_Evap_Blo_Fan_Cont                             : Float   := 0.0;


         -- digital output
         Oxygen_Lt                                         : Boolean := False;

         -- analog input
         Ecs_Temp_Cont                                     : Float := 0.0;
         Oxygen_Flow_Meter                                 : Boolean := False; --d/o!

         -- analog output

         -- spare
         Spare_Io_1                                        : Boolean := False;
      end record;

   Io_Size : constant Integer := 4;

   for Io_Interface_Instance use
      record
         --spare
         Spare_Io_1                                        at  000*Io_Size range 0..31;

         -- digital input
         Ecs_Temp_Cont_Man_Hot_Sw                          at  001*Io_Size range 0..31;
         Ecs_Temp_Cont_Man_Sw                              at  002*Io_Size range 0..31;
         Ecs_Temp_Cont_Man_Cold_Sw                         at  003*Io_Size range 0..31;
         Ecs_Temp_Cont_Auto_Sw                             at  004*Io_Size range 0..31;
         Ecs_Air_Cond_On_Sw                                at  005*Io_Size range 0..31;
         Ecs_Bleed_Air_Inflow_Hi_Sw                        at  006*Io_Size range 0..31;
         Ecs_Bleed_Air_Inflow_Off_Sw                       at  007*Io_Size range 0..31;
         Ecs_Press_Ram_Dump_Sw                             at  008*Io_Size range 0..31;
         Ecs_Press_Norm_Sw                                 at  009*Io_Size range 0..31;
         Ecs_Ram_Air_Flow_Hi_Sw                            at  010*Io_Size range 0..31;
         Ecs_Ram_Air_Flow_Off_Sw                           at  011*Io_Size range 0..31;
         Emer_Oxygen_Sw                                    at  012*Io_Size range 0..31;
         Test_Oxygen_Sw                                    at  013*Io_Size range 0..31;
         Oxygen_Max_Sw                                     at  014*Io_Size range 0..31;
         Bit_Sw                                            at  015*Io_Size range 0..31;
         Oxygen_Supply_On_Sw                               at  016*Io_Size range 0..31;
         Canopy_Fracture                                   at  017*Io_Size range 0..31;
         Canopy_Handle_Lock_Sw                             at  018*Io_Size range 0..31;
         Eject_Handle                                      at  019*Io_Size range 0..31;
         Inertia_Real_Mode_Select                          at  020*Io_Size range 0..31;
         Oxygen_Handle                                     at  021*Io_Size range 0..31;
         Oxygen_Connect                                    at  022*Io_Size range 0..31;
         Anti_Suffocation_Sw                               at  023*Io_Size range 0..31;
         Defog_Select_Sw_On                                at  024*Io_Size range 0..31;

         Ecs_Evap_Blo_Fan_On_Sw                            at  025*Io_Size range 0..31;
         Ecs_Evap_Blo_Fan_Cont                             at  026*Io_Size range 0..31;

         -- digital output
         Oxygen_Lt                                         at  027*Io_Size range 0..31;

         -- analog input
         Ecs_Temp_Cont                                     at  028*Io_Size range 0..31; --d/o!
         Oxygen_Flow_Meter                                 at  029*Io_Size range 0..31; --d/o!

         -- analog output

      end record;

   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         ------------------------------------------
         -- DEBUG
         -----------------------------------------
         Control_Valve_Position  : Float := 0.0;
         Control_Valve_Area      : Float := 0.0;
         Safety_Valve_Position   : Float := 0.0;
         Safety_Valve_Area       : Float := 0.0;
         Total_Leak_Area         : Float := 0.0;


         Flow_Into_Cockpit       : Float := 0.0;
         Flow_Out_of_Cockpit     : Float := 0.0;
         Total_Flow_Ppm          : Float := 0.0;
         Cockpit_Air_Mass        : Float := 0.0;

         Ambient_Pressure_Psi    : Float := 0.0;
         Ambient_Pressure_Alt    : Float := 0.0;

         Cockpit_Temp_F          : Float := 0.0;

         Cockpit_Roc             : Float := 0.0;
         Sac_Roc                 : Float := 0.0;

         Selected_Altitude          : Float := 0.0;
         Aircraft_Pressure_Altitude : Float := 0.0;
         ------------------------------------------
         -----------------------------------------
         -----------------------------------------

         Ejection_Velocity        : Float := 0.0;
         Ejection_Bank_Angle      : Float := 0.0;
         Ejection_Sink_Rate       : Float := 0.0;
         Ejection_Dive_Angle      : Float := 0.0;
         Ejection_Envelope_Height : Float := 0.0;
         Ejection_Altitude        : Float := 0.0;

         Is_Ejected               : Boolean := False;
         Ejection_Status          : Boolean := False;
         Auto_Temp_Control_Sw     : Float := 75.0;


         -- repeater vars
         Bleed_Inflow_Sw_State    : Integer := 0;
         Pressure_Sw_State        : Integer := 0;
         Ram_Air_Flow_Sw_State    : Integer := 0;
         Obogs_Sw_State           : Integer := 0;
         Oxygen_Sw_State          : Integer := 0;
         Supply_Sw_State          : Integer := 0;
         Defog_On_Sw              : Boolean := False;
         Ecs_Air_Cond_On_Sw       : Boolean := False;
         Ecs_Evap_Blo_Fan_On_Sw   : Boolean := False;
         Ecs_Evap_Blo_Fan_Cont    : Float   := 0.0;

         -- resets
         Eject_Reset              : Boolean := False;
         Canopy_Fracture_Reset    : Boolean := False;


         -- malfs
         Auto_Mode_Over_Temp_Malf : Boolean := False;
         Rapid_Decompression_Malf : Boolean := False;
         Slow_Decompression_Malf  : Boolean := False;
         Over_Pressure_Malf       : Boolean := False;
         Canopy_Annun_Malf        : Boolean := False;
         Obogs_Fail_Malf          : Boolean := False;
         Obogs_Heat_Exch_Malf     : Boolean := False;

         -- debug
         Cockpit_Pressure_Altitude     : Float := 1000.0;
         Cockpit_Differential_Pressure : Float := 0.0;

      end record;
   This_Ios_Interface : Ios_Interface_Instance;

   type Sound_Interface_Instance is
      record
         Canopy_Position                                   : Float := 0.0;
         Differential_Pressure                             : Float := 0.0;
         Pressure_System_Running                           : Float := 0.0;
         Air_Conditioning_System_Running                   : Float := 0.0;
         Windshield_Defrost_On                             : Float := 0.0;
         Explosive_Decompression                           : Float := 0.0;
      end record;
   This_Sound_Interface : Sound_Interface_Instance;

   type Host_Interface_Instance is
      record
         Ejection_Reset_Command : Boolean := False;
         Canopy_Fracture_Reset  : Boolean := False;
      end record;
   This_Host_Interface : Host_Interface_Instance;

end Jpats_Environmental.Container;
