-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  PRESSURIZATION SYSTEM
--  The pressurization system includes a control valve, a safety
--  valve, a control valve regulator, a differential pressure (delta
--  P) control and a solenoid dump valve. A pressure altitude
--  switch in the aircraft tail section prevents bleed air inflow
--  anytime the air conditioner clutch is engaged below 7500
--  feet MSL. The control valve regulator operates in conjunction
--  with the control valve to provide pressure control. The
--  delta P control operates in conjunction with the safety valve
--  to provide redundant control of maximum differential pressure.
--  The control valve is interconnected to a 28 VDC operated
--  dump solenoid, which requires power to close.
--  For normal operation, electrical power is removed from the
--  dump solenoid through the landing gear weight-on-wheels
--  switch when the aircraft is on the ground. When the aircraft
--  becomes airborne, electrical power is applied to the solenoid,
--  allowing the control valve to regulate cockpit pressure
--  altitude when approaching 8000 feet pressure altitude. An
--  8000 foot cockpit altitude is maintained until a differential
--  pressure of 3.6  0.1 psi is reached at 18,069 feet. Cockpit
--  pressure altitude at 31,000 feet is 18,500 feet. To dump
--  cockpit pressure, either the DUMP or RAM DUMP mode
--  may be selected. In either dump mode, electrical power to
--  the dump solenoid is interrupted, which results in the control
--  valve opening. In the DUMP mode, bleed air inflow
--  continues. In the RAM DUMP mode, bleed air inflow is terminated
--  and the fresh air ventilation shutoff valve opens.
--  NOTE
--  If readings other than 3.6  0.1 psi are
--  encountered at or above 18,000 feet MSL,
--  notify maintenance.
--  If cockpit pressure altitude rises above 19,000 feet, an
--  amber CKPT ALT annunciator illuminates. If cockpit differential
--  pressure exceeds 3.9  0.1 psi, a red CKPT PX
--  annunciator illuminates. Cockpit differential pressure and
--  cockpit altitude are displayed on the alternate engine data
--  displays in each cockpit. In the upper right corner of the
--  EID, the cockpit pressure altitude is presented in feet, placarded
--  COCKPIT ALT, FT. The cockpit differential Pressure
--  display, placarded DP, PSI, is just below the cockpit pressure
--  altitude display.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------

private package Jpats_Environmental.Cockpit_Pressure_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Environmental.Cockpit_Pressure_Controller;
