-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  CANOPY
--  The lockable canopy (Figure 1-33), which includes the
--  windscreen, is side opening. For birdstrike protection, the
--  windscreen and front transparency are thicker than the rear
--  transparency. Oil filled spring struts permit opening and
--  closing without power assist from either cockpit. The latch
--  mechanism drives five overcentering hooks through a continuous
--  drive rod. An electrical sensing system verifies the
--  locked and latched condition. A red CANOPY annunciator
--  illuminates when the canopy latch mechanism and
--  microswitches do not indicate the canopy is in the closed
--  and locked position. For defog and ventilation, warm air is
--  routed through tubes along the sides of the canopy and distributed
--  through a series of flow control holes.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.

-------------------------------------------------------------------------------

private package Jpats_Environmental.Canopy_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Environmental.Canopy_Controller;
