-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Environmental.Container;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Log;

package body Jpats_Environmental.Canopy_Controller is

   procedure Initialize
   is
      package Ctnr   renames Container;
      package Canopy renames Ctnr.Canopy;
      The_Canopy : Canopy.Instance renames Ctnr.This_Subsystem.The_Canopy;
   begin
      Canopy.Initialize (The_Canopy);
   exception
      when others =>
         Log.Report("Jpats_Environmental.Canopy_Controller.Initialize()");
         raise;
   end Initialize;


   Canopy_Fracture_Last_Pass : Boolean renames Container.This_Subsystem.CC_Canopy_Fracture_Last_Pass;
   Canopy_Is_Fractured : Boolean  renames Container.This_Subsystem.CC_Canopy_Is_Fractured;
   Canopy_Is_Fractured_Last_Pass : Boolean renames Container.This_Subsystem.CC_Canopy_Is_Fractured_Last_Pass;

   procedure Update
     (Iconst : in Float)
   is

      package Ctnr   renames Container;
      package Canopy renames Ctnr.Canopy;
      package Seat   renames Ctnr.Ejection_Seat;

      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
      Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;
      Host : Ctnr.Host_Interface_Instance renames Ctnr.This_Host_Interface;

      The_Canopy : Canopy.Instance renames Ctnr.This_Subsystem.The_Canopy;
      The_Seat : Seat.Instance renames Ctnr.This_Subsystem.The_Ejection_Seat;

   begin


      ---------------------
      -- CANOPY FRACTURE --
      ---------------------

      if (Io.Canopy_Fracture and not Canopy_Fracture_Last_Pass) or Seat.Is_Ejected(The_Seat) then
         Canopy_Is_Fractured := True;
      else
         if ((Ios.Canopy_Fracture_Reset or Host.Canopy_Fracture_Reset)
             or not Seat.Is_Ejected(The_Seat))
           and not Io.Canopy_Fracture then
            Canopy_Is_Fractured := False;
            Ios.Canopy_Fracture_Reset := False;
            Host.Canopy_Fracture_Reset := False;
         end if;
      end if;

      Canopy_Fracture_Last_Pass := Canopy_Is_Fractured;


      ------------------
      -- CANOPY LATCH --
      ------------------

      Canopy.Update
        (An_Instance   => The_Canopy,
         Latched       => Io.CANOPY_HANDLE_LOCK_SW,
         Latch_Malf    => False,
         Fracture_Cmd => Canopy_Is_Fractured);


      if Canopy.Is_Fractured(The_Canopy) /= Canopy_Is_Fractured_Last_Pass then
         if Canopy.Is_Fractured(The_Canopy) then Log.Report("canopy is fractured");
         else Log.Report("canopy is NOT fractured"); end if;
      end if;

      Canopy_Is_Fractured_Last_Pass := Canopy.Is_Fractured(The_Canopy);

      -----------
      -- SOUND --
      -----------

      Sound.Canopy_Position := 0.0;


   exception
      when others =>
         Log.Report("Jpats_Environmental.Canopy_Controller.Update()");
         raise;
   end Update;

end Jpats_Environmental.Canopy_Controller;
